/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.index.Index;

public class DanglingIndicesState
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(DanglingIndicesState.class);
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    private final Map<Index, IndexMetadata> danglingIndices = ConcurrentCollections.newConcurrentMap();

    @Inject
    public DanglingIndicesState(NodeEnvironment nodeEnv, MetaStateService metaStateService, LocalAllocateDangledIndices allocateDangledIndices, ClusterService clusterService) {
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.allocateDangledIndices = allocateDangledIndices;
        clusterService.addListener(this);
    }

    public void processDanglingIndices(Metadata metadata) {
        if (!this.nodeEnv.hasNodeFile()) {
            return;
        }
        this.cleanupAllocatedDangledIndices(metadata);
        this.findNewAndAddDanglingIndices(metadata);
        this.allocateDanglingIndices();
    }

    Map<Index, IndexMetadata> getDanglingIndices() {
        return Map.copyOf(this.danglingIndices);
    }

    void cleanupAllocatedDangledIndices(Metadata metadata) {
        for (Index index : this.danglingIndices.keySet()) {
            IndexMetadata indexMetadata = metadata.index(index);
            if (indexMetadata == null || !indexMetadata.getIndex().getName().equals(index.getName())) continue;
            if (!indexMetadata.getIndex().getUUID().equals(index.getUUID())) {
                LOGGER.warn("[{}] can not be imported as a dangling index, as there is already another index with the same name but a different uuid. local index will be ignored (but not deleted)", (Object)index);
            } else {
                LOGGER.debug("[{}] no longer dangling (created), removing from dangling list", (Object)index);
            }
            this.danglingIndices.remove(index);
        }
    }

    void findNewAndAddDanglingIndices(Metadata metadata) {
        this.danglingIndices.putAll(this.findNewDanglingIndices(metadata));
    }

    Map<Index, IndexMetadata> findNewDanglingIndices(Metadata metadata) {
        HashSet<String> excludeIndexPathIds = new HashSet<String>(metadata.indices().size() + this.danglingIndices.size());
        for (ObjectCursor cursor : metadata.indices().values()) {
            excludeIndexPathIds.add(((IndexMetadata)cursor.value).getIndex().getUUID());
        }
        excludeIndexPathIds.addAll(this.danglingIndices.keySet().stream().map(Index::getUUID).collect(Collectors.toList()));
        try {
            List<IndexMetadata> indexMetadataList = this.metaStateService.loadIndicesStates(excludeIndexPathIds::contains);
            HashMap<Index, IndexMetadata> newIndices = new HashMap<Index, IndexMetadata>(indexMetadataList.size());
            IndexGraveyard graveyard = metadata.indexGraveyard();
            for (IndexMetadata indexMetadata : indexMetadataList) {
                if (metadata.hasIndex(indexMetadata.getIndex().getName())) {
                    LOGGER.warn("[{}] can not be imported as a dangling index, as index with same name already exists in cluster metadata", (Object)indexMetadata.getIndex());
                    continue;
                }
                if (graveyard.containsIndex(indexMetadata.getIndex())) {
                    LOGGER.warn("[{}] can not be imported as a dangling index, as an index with the same name and UUID exist in the index tombstones.  This situation is likely caused by copying over the data directory for an index that was previously deleted.", (Object)indexMetadata.getIndex());
                    continue;
                }
                LOGGER.info("[{}] dangling index exists on local file system, but not in cluster metadata, auto import to cluster state", (Object)indexMetadata.getIndex());
                newIndices.put(indexMetadata.getIndex(), indexMetadata);
            }
            return newIndices;
        }
        catch (IOException e) {
            LOGGER.warn("failed to list dangling indices", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private void allocateDanglingIndices() {
        if (this.danglingIndices.isEmpty()) {
            return;
        }
        try {
            this.allocateDangledIndices.allocateDangled(Collections.unmodifiableCollection(new ArrayList<IndexMetadata>(this.danglingIndices.values())), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                @Override
                public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                    LOGGER.trace("allocated dangled");
                }

                @Override
                public void onFailure(Exception e) {
                    LOGGER.info("failed to send allocated dangled", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("failed to send allocate dangled", (Throwable)e);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.state().blocks().disableStatePersistence()) {
            this.processDanglingIndices(event.state().metadata());
        }
    }
}

