/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import io.crate.common.unit.TimeValue;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

final class Ec2ClientSettings {
    static final Setting<SecureString> ACCESS_KEY_SETTING = Setting.maskedString("discovery.ec2.access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = Setting.maskedString("discovery.ec2.secret_key");
    static final Setting<SecureString> SESSION_TOKEN_SETTING = Setting.maskedString("discovery.ec2.session_token");
    static final Setting<String> PROXY_HOST_SETTING = Setting.simpleString("discovery.ec2.proxy.host", Setting.Property.NodeScope);
    static final Setting<Integer> PROXY_PORT_SETTING = Setting.intSetting("discovery.ec2.proxy.port", 80, 0, 65536, Setting.Property.NodeScope);
    static final Setting<String> ENDPOINT_SETTING = new Setting<String>("discovery.ec2.endpoint", "", s -> s.toLowerCase(Locale.ROOT), Setting.Property.NodeScope);
    static final Setting<Protocol> PROTOCOL_SETTING = new Setting<Protocol>("discovery.ec2.protocol", "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), Setting.Property.NodeScope);
    static final Setting<SecureString> PROXY_USERNAME_SETTING = Setting.maskedString("discovery.ec2.proxy.username");
    static final Setting<SecureString> PROXY_PASSWORD_SETTING = Setting.maskedString("discovery.ec2.proxy.password");
    static final Setting<TimeValue> READ_TIMEOUT_SETTING = Setting.timeSetting("discovery.ec2.read_timeout", TimeValue.timeValueMillis(50000L), Setting.Property.NodeScope);
    private static final Logger LOGGER = LogManager.getLogger(Ec2ClientSettings.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LOGGER);
    final AWSCredentials credentials;
    final String endpoint;
    final Protocol protocol;
    final String proxyHost;
    final int proxyPort;
    final String proxyUsername;
    final String proxyPassword;
    final int readTimeoutMillis;

    protected Ec2ClientSettings(AWSCredentials credentials, String endpoint, Protocol protocol, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, int readTimeoutMillis) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    /*
     * Exception decompiling
     */
    static AWSCredentials loadCredentials(Settings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Ec2ClientSettings getClientSettings(Settings settings) {
        AWSCredentials credentials = Ec2ClientSettings.loadCredentials(settings);
        try (SecureString proxyUsername = PROXY_USERNAME_SETTING.get(settings);){
            SecureString proxyPassword = PROXY_PASSWORD_SETTING.get(settings);
            try {
                Ec2ClientSettings ec2ClientSettings = new Ec2ClientSettings(credentials, ENDPOINT_SETTING.get(settings), PROTOCOL_SETTING.get(settings), PROXY_HOST_SETTING.get(settings), PROXY_PORT_SETTING.get(settings), proxyUsername.toString(), proxyPassword.toString(), (int)READ_TIMEOUT_SETTING.get(settings).millis());
                if (proxyPassword != null) {
                    proxyPassword.close();
                }
                return ec2ClientSettings;
            }
            catch (Throwable throwable) {
                if (proxyPassword != null) {
                    try {
                        proxyPassword.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

