/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.discovery.ec2.AmazonEc2Reference;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;

interface AwsEc2Service
extends Closeable {
    public static final Setting<Boolean> AUTO_ATTRIBUTE_SETTING = Setting.boolSetting("cloud.node.auto_attributes", false, Setting.Property.NodeScope);
    public static final Setting<String> HOST_TYPE_SETTING = new Setting("discovery.ec2.host_type", "private_ip", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<Boolean> ANY_GROUP_SETTING = Setting.boolSetting("discovery.ec2.any_group", true, Setting.Property.NodeScope);
    public static final Setting<List<String>> GROUPS_SETTING = Setting.listSetting("discovery.ec2.groups", new ArrayList<String>(), s -> s.toString(), Setting.Property.NodeScope);
    public static final Setting<List<String>> AVAILABILITY_ZONES_SETTING = Setting.listSetting("discovery.ec2.availability_zones", Collections.emptyList(), s -> s.toString(), Setting.Property.NodeScope);
    public static final Setting<TimeValue> NODE_CACHE_TIME_SETTING = Setting.timeSetting("discovery.ec2.node_cache_time", TimeValue.timeValueSeconds(10L), Setting.Property.NodeScope);
    public static final Setting.AffixSetting<List<String>> TAG_SETTING = Setting.prefixKeySetting("discovery.ec2.tag.", key -> Setting.listSetting(key, Collections.emptyList(), Function.identity(), Setting.Property.NodeScope));

    public AmazonEc2Reference client();

    public void refreshAndClearCache(Ec2ClientSettings var1);

    public static class HostType {
        public static final String PRIVATE_IP = "private_ip";
        public static final String PUBLIC_IP = "public_ip";
        public static final String PRIVATE_DNS = "private_dns";
        public static final String PUBLIC_DNS = "public_dns";
        public static final String TAG_PREFIX = "tag:";
    }
}

