/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.IOException;
import org.elasticsearch.cluster.coordination.PendingClusterStateStats;
import org.elasticsearch.cluster.coordination.PublishClusterStateStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    private final PendingClusterStateStats queueStats;
    private final PublishClusterStateStats publishStats;

    public DiscoveryStats(PendingClusterStateStats queueStats, PublishClusterStateStats publishStats) {
        this.queueStats = queueStats;
        this.publishStats = publishStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = in.readOptionalWriteable(PendingClusterStateStats::new);
        this.publishStats = in.readOptionalWriteable(PublishClusterStateStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.queueStats);
        out.writeOptionalWriteable(this.publishStats);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        if (this.publishStats != null) {
            this.publishStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    public PublishClusterStateStats getPublishStats() {
        return this.publishStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

