/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import io.crate.common.collections.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public final class ListenableFuture<V>
extends BaseFuture<V>
implements ActionListener<V> {
    private volatile boolean done = false;
    private final List<Tuple<ActionListener<V>, Executor>> listeners = new ArrayList<Tuple<ActionListener<V>, Executor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ActionListener<V> listener, Executor executor) {
        if (this.done) {
            this.notifyListener(listener, EsExecutors.directExecutor());
        } else {
            boolean run;
            ListenableFuture listenableFuture = this;
            synchronized (listenableFuture) {
                if (this.done) {
                    run = true;
                } else {
                    this.listeners.add(new Tuple<ActionListener<V>, Executor>(listener, executor));
                    run = false;
                }
            }
            if (run) {
                this.notifyListener(listener, EsExecutors.directExecutor());
            }
        }
    }

    @Override
    protected synchronized void done() {
        this.done = true;
        this.listeners.forEach(t -> this.notifyListener((ActionListener)t.v1(), (Executor)t.v2()));
        this.listeners.clear();
    }

    private void notifyListener(ActionListener<V> listener, Executor executor) {
        try {
            executor.execute(new ActionRunnable<V>(listener){

                @Override
                protected void doRun() {
                    Object value = FutureUtils.get(ListenableFuture.this, 0L, TimeUnit.NANOSECONDS);
                    this.listener.onResponse(value);
                }

                public String toString() {
                    return "ListenableFuture notification";
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public void onResponse(V v) {
        boolean set = this.set(v);
        if (!set) {
            throw new IllegalStateException("did not set value, value or exception already set?");
        }
    }

    @Override
    public void onFailure(Exception e) {
        boolean set = this.setException(e);
        if (!set) {
            throw new IllegalStateException("did not set exception, value already set or exception already set?");
        }
    }
}

