/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.hppc.ObjectArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.lucene.util.IntroSorter;

public class CollectionUtils {
    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> List<T> rotate(List<T> list, int distance) {
        if (list.isEmpty()) {
            return list;
        }
        int d = distance % list.size();
        if (d < 0) {
            d += list.size();
        }
        if (d == 0) {
            return list;
        }
        return new RotatedList<T>(list, d);
    }

    public static void sortAndDedup(ObjectArrayList<byte[]> array) {
        int len = array.size();
        if (len > 1) {
            CollectionUtils.sort(array);
            int uniqueCount = 1;
            for (int i = 1; i < len; ++i) {
                if (Arrays.equals((byte[])array.get(i), (byte[])array.get(i - 1))) continue;
                array.set(uniqueCount++, (Object)((byte[])array.get(i)));
            }
            array.elementsCount = uniqueCount;
        }
    }

    public static void sort(final ObjectArrayList<byte[]> array) {
        new IntroSorter(){
            byte[] pivot;

            protected void swap(int i, int j) {
                byte[] tmp = (byte[])array.get(i);
                array.set(i, (Object)((byte[])array.get(j)));
                array.set(j, (Object)tmp);
            }

            protected int compare(int i, int j) {
                return this.compare((byte[])array.get(i), (byte[])array.get(j));
            }

            protected void setPivot(int i) {
                this.pivot = (byte[])array.get(i);
            }

            protected int comparePivot(int j) {
                return this.compare(this.pivot, (byte[])array.get(j));
            }

            private int compare(byte[] left, byte[] right) {
                int i = 0;
                for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                    int a = left[i] & 0xFF;
                    int b = right[j] & 0xFF;
                    if (a == b) continue;
                    return a - b;
                }
                return left.length - right.length;
            }
        }.sort(0, array.size());
    }

    public static int[] toArray(Collection<Integer> ints) {
        Objects.requireNonNull(ints);
        return ints.stream().mapToInt(s -> s).toArray();
    }

    public static <E> ArrayList<E> iterableAsArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> arrayAsArrayList(E ... elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        return new ArrayList<E>(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <E> ArrayList<E> asArrayList(E first, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(1 + other.length);
        list.add(first);
        list.addAll(Arrays.asList(other));
        return list;
    }

    @SafeVarargs
    public static <E> ArrayList<E> asArrayList(E first, E second, E ... other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        ArrayList<E> list = new ArrayList<E>(2 + other.length);
        list.add(first);
        list.add(second);
        list.addAll(Arrays.asList(other));
        return list;
    }

    private static class RotatedList<T>
    extends AbstractList<T>
    implements RandomAccess {
        private final List<T> in;
        private final int distance;

        RotatedList(List<T> list, int distance) {
            if (distance < 0 || distance >= list.size()) {
                throw new IllegalArgumentException();
            }
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException();
            }
            this.in = list;
            this.distance = distance;
        }

        @Override
        public T get(int index) {
            int idx = this.distance + index;
            if (idx < 0 || idx >= this.in.size()) {
                idx -= this.in.size();
            }
            return this.in.get(idx);
        }

        @Override
        public int size() {
            return this.in.size();
        }
    }
}

