/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;

public final class ByteUtils
extends Enum<ByteUtils> {
    private static final /* synthetic */ ByteUtils[] $VALUES;

    public static ByteUtils[] values() {
        return (ByteUtils[])$VALUES.clone();
    }

    public static ByteUtils valueOf(String name) {
        return Enum.valueOf(ByteUtils.class, name);
    }

    public static long readLongLE(byte[] arr, int offset) {
        long l = (long)arr[offset++] & 0xFFL;
        for (int i = 1; i < 8; ++i) {
            l |= ((long)arr[offset++] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static int readIntLE(byte[] arr, int offset) {
        int l = arr[offset++] & 0xFF;
        for (int i = 1; i < 4; ++i) {
            l |= (arr[offset++] & 0xFF) << 8 * i;
        }
        return l;
    }

    public static void writeVLong(ByteArrayDataOutput out, long i) {
        for (int k = 0; k < 8 && (i & 0xFFFFFFFFFFFFFF80L) != 0L; ++k) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static long readVLong(ByteArrayDataInput in) {
        byte b = in.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        return i |= ((long)b & 0xFFL) << 56;
    }

    private static /* synthetic */ ByteUtils[] $values() {
        return new ByteUtils[0];
    }

    static {
        $VALUES = ByteUtils.$values();
    }
}

