/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArray;
import org.elasticsearch.common.util.BigByteArray;
import org.elasticsearch.common.util.BigIntArray;
import org.elasticsearch.common.util.BigObjectArray;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class BigArrays {
    public static final BigArrays NON_RECYCLING_INSTANCE = new BigArrays(null, null, "request");
    final PageCacheRecycler recycler;
    private final CircuitBreakerService breakerService;
    private final boolean checkBreaker;
    private final String breakerName;

    public static long overSize(long minTargetSize, int pageSize, int bytesPerElement) {
        if (minTargetSize < 0L) {
            throw new IllegalArgumentException("minTargetSize must be >= 0");
        }
        if (pageSize < 0) {
            throw new IllegalArgumentException("pageSize must be > 0");
        }
        if (bytesPerElement <= 0) {
            throw new IllegalArgumentException("bytesPerElement must be > 0");
        }
        long newSize = minTargetSize < (long)pageSize ? (long)ArrayUtil.oversize((int)((int)minTargetSize), (int)bytesPerElement) : minTargetSize + (minTargetSize >>> 3);
        if (newSize > (long)pageSize) {
            newSize = newSize - newSize % (long)pageSize + (long)pageSize;
            assert (newSize % (long)pageSize == 0L);
        }
        return newSize;
    }

    static boolean indexIsInt(long index) {
        return index == (long)((int)index);
    }

    public BigArrays(PageCacheRecycler recycler, @Nullable CircuitBreakerService breakerService, String breakerName) {
        this(recycler, breakerService, breakerName, false);
    }

    public BigArrays(PageCacheRecycler recycler, @Nullable CircuitBreakerService breakerService, String breakerName, boolean checkBreaker) {
        this.checkBreaker = checkBreaker;
        this.recycler = recycler;
        this.breakerService = breakerService;
        this.breakerName = breakerName;
    }

    void adjustBreaker(long delta, boolean isDataAlreadyCreated) {
        if (this.breakerService != null) {
            CircuitBreaker breaker = this.breakerService.getBreaker(this.breakerName);
            if (this.checkBreaker) {
                if (delta > 0L) {
                    try {
                        breaker.addEstimateBytesAndMaybeBreak(delta, "<reused_arrays>");
                    }
                    catch (CircuitBreakingException e) {
                        if (isDataAlreadyCreated) {
                            breaker.addWithoutBreaking(delta);
                        }
                        throw e;
                    }
                } else {
                    breaker.addWithoutBreaking(delta);
                }
            } else {
                breaker.addWithoutBreaking(delta);
            }
        }
    }

    private <T extends AbstractBigArray> T resizeInPlace(T array, long newSize) {
        long oldMemSize = array.ramBytesUsed();
        long oldSize = array.size();
        assert (oldMemSize == array.ramBytesEstimated(oldSize)) : "ram bytes used should equal that which was previously estimated: ramBytesUsed=" + oldMemSize + ", ramBytesEstimated=" + array.ramBytesEstimated(oldSize);
        long estimatedIncreaseInBytes = array.ramBytesEstimated(newSize) - oldMemSize;
        this.adjustBreaker(estimatedIncreaseInBytes, false);
        array.resize(newSize);
        return array;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends BigArray> T validate(T array) {
        boolean success = false;
        try {
            this.adjustBreaker(array.ramBytesUsed(), true);
            return array;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.closeWhileHandlingException(array);
            throw throwable;
        }
    }

    public ByteArray newByteArray(long size, boolean clearOnResize) {
        if (size > 16384L) {
            this.adjustBreaker(BigByteArray.estimateRamBytes(size), false);
            return new BigByteArray(size, this, clearOnResize);
        }
        if (size >= 8192L && this.recycler != null) {
            Recycler.V<byte[]> page = this.recycler.bytePage(clearOnResize);
            return this.validate(new ByteArrayWrapper(this, page.v(), size, page, clearOnResize));
        }
        return this.validate(new ByteArrayWrapper(this, new byte[(int)size], size, null, clearOnResize));
    }

    public ByteArray newByteArray(long size) {
        return this.newByteArray(size, true);
    }

    public ByteArray resize(ByteArray array, long size) {
        if (array instanceof BigByteArray) {
            return this.resizeInPlace((BigByteArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        ByteArray newArray = this.newByteArray(size, arr.clearOnResize);
        byte[] rawArray = ((ByteArrayWrapper)array).array;
        newArray.set(0L, rawArray, 0, (int)Math.min((long)rawArray.length, newArray.size()));
        arr.close();
        return newArray;
    }

    public ByteArray grow(ByteArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 16384, 1);
        return this.resize(array, newSize);
    }

    public int hashCode(ByteArray array) {
        if (array == null) {
            return 0;
        }
        int hash = 1;
        for (long i = 0L; i < array.size(); ++i) {
            hash = 31 * hash + array.get(i);
        }
        return hash;
    }

    public boolean equals(ByteArray array, ByteArray other) {
        if (array == other) {
            return true;
        }
        if (array.size() != other.size()) {
            return false;
        }
        for (long i = 0L; i < array.size(); ++i) {
            if (array.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public IntArray newIntArray(long size, boolean clearOnResize) {
        if (size > 4096L) {
            this.adjustBreaker(BigIntArray.estimateRamBytes(size), false);
            return new BigIntArray(size, this, clearOnResize);
        }
        if (size >= 2048L && this.recycler != null) {
            Recycler.V<int[]> page = this.recycler.intPage(clearOnResize);
            return this.validate(new IntArrayWrapper(this, page.v(), size, page, clearOnResize));
        }
        return this.validate(new IntArrayWrapper(this, new int[(int)size], size, null, clearOnResize));
    }

    public IntArray newIntArray(long size) {
        return this.newIntArray(size, true);
    }

    public IntArray resize(IntArray array, long size) {
        if (array instanceof BigIntArray) {
            return this.resizeInPlace((BigIntArray)array, size);
        }
        AbstractArray arr = (AbstractArray)((Object)array);
        IntArray newArray = this.newIntArray(size, arr.clearOnResize);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.close();
        return newArray;
    }

    public IntArray grow(IntArray array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, 4096, 4);
        return this.resize(array, newSize);
    }

    public <T> ObjectArray<T> newObjectArray(long size) {
        if (size > (long)PageCacheRecycler.OBJECT_PAGE_SIZE) {
            this.adjustBreaker(BigObjectArray.estimateRamBytes(size), false);
            return new BigObjectArray(size, this);
        }
        if (size >= (long)(PageCacheRecycler.OBJECT_PAGE_SIZE / 2) && this.recycler != null) {
            Recycler.V<Object[]> page = this.recycler.objectPage();
            return this.validate(new ObjectArrayWrapper(this, page.v(), size, page));
        }
        return this.validate(new ObjectArrayWrapper(this, new Object[(int)size], size, null));
    }

    public <T> ObjectArray<T> resize(ObjectArray<T> array, long size) {
        if (array instanceof BigObjectArray) {
            return this.resizeInPlace((BigObjectArray)array, size);
        }
        ObjectArray<T> newArray = this.newObjectArray(size);
        long end = Math.min(size, array.size());
        for (long i = 0L; i < end; ++i) {
            newArray.set(i, array.get(i));
        }
        array.close();
        return newArray;
    }

    public <T> ObjectArray<T> grow(ObjectArray<T> array, long minSize) {
        if (minSize <= array.size()) {
            return array;
        }
        long newSize = BigArrays.overSize(minSize, PageCacheRecycler.OBJECT_PAGE_SIZE, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        return this.resize(array, newSize);
    }

    private static class ByteArrayWrapper
    extends AbstractArrayWrapper
    implements ByteArray {
        private final byte[] array;

        ByteArrayWrapper(BigArrays bigArrays, byte[] array, long size, Recycler.V<byte[]> releasable, boolean clearOnResize) {
            super(bigArrays, size, releasable, clearOnResize);
            this.array = array;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.array);
        }

        @Override
        public byte get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public byte set(long index, byte value) {
            assert (BigArrays.indexIsInt(index));
            byte ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public boolean get(long index, int len, BytesRef ref) {
            assert (BigArrays.indexIsInt(index));
            ref.bytes = this.array;
            ref.offset = (int)index;
            ref.length = len;
            return false;
        }

        @Override
        public void set(long index, byte[] buf, int offset, int len) {
            assert (BigArrays.indexIsInt(index));
            System.arraycopy(buf, offset, this.array, (int)index, len);
        }

        @Override
        public void fill(long fromIndex, long toIndex, byte value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class IntArrayWrapper
    extends AbstractArrayWrapper
    implements IntArray {
        private final int[] array;

        IntArrayWrapper(BigArrays bigArrays, int[] array, long size, Recycler.V<int[]> releasable, boolean clearOnResize) {
            super(bigArrays, size, releasable, clearOnResize);
            this.array = array;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((int[])this.array);
        }

        @Override
        public int get(long index) {
            assert (BigArrays.indexIsInt(index));
            return this.array[(int)index];
        }

        @Override
        public int set(long index, int value) {
            assert (BigArrays.indexIsInt(index));
            int ret = this.array[(int)index];
            this.array[(int)index] = value;
            return ret;
        }

        @Override
        public int increment(long index, int inc) {
            assert (BigArrays.indexIsInt(index));
            int n = (int)index;
            int n2 = this.array[n] + inc;
            this.array[n] = n2;
            return n2;
        }

        @Override
        public void fill(long fromIndex, long toIndex, int value) {
            assert (BigArrays.indexIsInt(fromIndex));
            assert (BigArrays.indexIsInt(toIndex));
            Arrays.fill(this.array, (int)fromIndex, (int)toIndex, value);
        }
    }

    private static class ObjectArrayWrapper<T>
    extends AbstractArrayWrapper
    implements ObjectArray<T> {
        private final Object[] array;

        ObjectArrayWrapper(BigArrays bigArrays, Object[] array, long size, Recycler.V<Object[]> releasable) {
            super(bigArrays, size, releasable, true);
            this.array = array;
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * this.size()));
        }

        @Override
        public T get(long index) {
            assert (BigArrays.indexIsInt(index));
            return (T)this.array[(int)index];
        }

        @Override
        public T set(long index, T value) {
            assert (BigArrays.indexIsInt(index));
            Object ret = this.array[(int)index];
            this.array[(int)index] = value;
            return (T)ret;
        }
    }

    private static abstract class AbstractArrayWrapper
    extends AbstractArray
    implements BigArray {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ByteArrayWrapper.class);
        private final Releasable releasable;
        private final long size;

        AbstractArrayWrapper(BigArrays bigArrays, long size, Releasable releasable, boolean clearOnResize) {
            super(bigArrays, clearOnResize);
            this.releasable = releasable;
            this.size = size;
        }

        @Override
        public final long size() {
            return this.size;
        }

        @Override
        protected final void doClose() {
            Releasables.close(this.releasable);
        }
    }
}

