/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

public enum DistanceUnit {
    INCH(0.0254, "in", "inch"),
    YARD(0.9144, "yd", "yards"),
    FEET(0.3048, "ft", "feet"),
    KILOMETERS(1000.0, "km", "kilometers"),
    NAUTICALMILES(1852.0, "NM", "nmi", "nauticalmiles"),
    MILLIMETERS(0.001, "mm", "millimeters"),
    CENTIMETERS(0.01, "cm", "centimeters"),
    MILES(1609.344, "mi", "miles"),
    METERS(1.0, "m", "meters");

    public static final DistanceUnit DEFAULT;
    private double meters;
    private final String[] names;

    private DistanceUnit(double meters, String ... names) {
        this.meters = meters;
        this.names = names;
    }

    public double getEarthCircumference() {
        return 4.007501668557849E7 / this.meters;
    }

    public String toString(double distance) {
        return distance + this.toString();
    }

    public String toString() {
        return this.names[0];
    }

    public static double convert(double distance, DistanceUnit from, DistanceUnit to) {
        if (from == to) {
            return distance;
        }
        return distance * from.meters / to.meters;
    }

    public static double parse(String distance, DistanceUnit defaultUnit, DistanceUnit to) {
        Distance dist = Distance.parseDistance(distance, defaultUnit);
        return DistanceUnit.convert(dist.value, dist.unit, to);
    }

    public double parse(String distance, DistanceUnit defaultUnit) {
        return DistanceUnit.parse(distance, defaultUnit, this);
    }

    public static DistanceUnit fromString(String unit) {
        for (DistanceUnit dunit : DistanceUnit.values()) {
            for (String name : dunit.names) {
                if (!name.equals(unit)) continue;
                return dunit;
            }
        }
        throw new IllegalArgumentException("No distance unit match [" + unit + "]");
    }

    static {
        DEFAULT = METERS;
    }

    public static class Distance
    implements Comparable<Distance> {
        public final double value;
        public final DistanceUnit unit;

        public Distance(double value, DistanceUnit unit) {
            this.value = value;
            this.unit = unit;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof Distance) {
                Distance other = (Distance)obj;
                return DistanceUnit.convert(this.value, this.unit, other.unit) == other.value;
            }
            return false;
        }

        public int hashCode() {
            return Double.valueOf(this.value * this.unit.meters).hashCode();
        }

        @Override
        public int compareTo(Distance o) {
            return Double.compare(this.value, DistanceUnit.convert(o.value, o.unit, this.unit));
        }

        public String toString() {
            return this.unit.toString(this.value);
        }

        public static Distance parseDistance(String distance) {
            return Distance.parseDistance(distance, DEFAULT);
        }

        private static Distance parseDistance(String distance, DistanceUnit defaultUnit) {
            for (DistanceUnit unit : DistanceUnit.values()) {
                for (String name : unit.names) {
                    if (!distance.endsWith(name)) continue;
                    return new Distance(Double.parseDouble(distance.substring(0, distance.length() - name.length())), unit);
                }
            }
            return new Distance(Double.parseDouble(distance), defaultUnit);
        }
    }
}

