/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import org.elasticsearch.common.transport.TransportAddress;

public class BoundTransportAddress {
    private TransportAddress[] boundAddresses;
    private TransportAddress publishAddress;

    public BoundTransportAddress(TransportAddress[] boundAddresses, TransportAddress publishAddress) {
        if (boundAddresses == null || boundAddresses.length < 1) {
            throw new IllegalArgumentException("at least one bound address must be provided");
        }
        this.boundAddresses = boundAddresses;
        this.publishAddress = publishAddress;
    }

    public TransportAddress[] boundAddresses() {
        return this.boundAddresses;
    }

    public TransportAddress publishAddress() {
        return this.publishAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("publish_address {");
        builder.append(this.publishAddress);
        builder.append("}, bound_addresses ");
        boolean firstAdded = false;
        for (TransportAddress address : this.boundAddresses) {
            if (firstAdded) {
                builder.append(", ");
            } else {
                firstAdded = true;
            }
            builder.append("{").append(address).append("}");
        }
        return builder.toString();
    }
}

