/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.time.DateFormatter;

class EpochMillisDateFormatter
implements DateFormatter {
    private static final Pattern SPLIT_BY_DOT_PATTERN = Pattern.compile("\\.");
    static DateFormatter INSTANCE = new EpochMillisDateFormatter();

    private EpochMillisDateFormatter() {
    }

    @Override
    public TemporalAccessor parse(String input) {
        try {
            if (input.contains(".")) {
                String[] inputs = SPLIT_BY_DOT_PATTERN.split(input, 2);
                Long milliSeconds = Long.valueOf(inputs[0]);
                if (inputs[1].length() == 0) {
                    return Instant.ofEpochMilli(milliSeconds).atZone(ZoneOffset.UTC);
                }
                if (inputs[1].contains("e")) {
                    return Instant.ofEpochMilli(Double.valueOf(input).longValue()).atZone(ZoneOffset.UTC);
                }
                if (inputs[1].length() > 6) {
                    throw new DateTimeParseException("too much granularity after dot [" + input + "]", input, 0);
                }
                long nanos = new BigDecimal(inputs[1]).movePointRight(6 - inputs[1].length()).longValueExact();
                if (milliSeconds < 0L) {
                    nanos *= -1L;
                }
                return Instant.ofEpochMilli(milliSeconds).plusNanos(nanos).atZone(ZoneOffset.UTC);
            }
            return Instant.ofEpochMilli(Long.valueOf(input)).atZone(ZoneOffset.UTC);
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("invalid number [" + input + "]", input, 0, e);
        }
    }

    @Override
    public DateFormatter withZone(ZoneId zoneId) {
        if (!ZoneOffset.UTC.equals(zoneId)) {
            throw new IllegalArgumentException(this.pattern() + " date formatter can only be in zone offset UTC");
        }
        return INSTANCE;
    }

    @Override
    public DateFormatter withLocale(Locale locale) {
        if (!Locale.ROOT.equals(locale)) {
            throw new IllegalArgumentException(this.pattern() + " date formatter can only be in locale ROOT");
        }
        return this;
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return String.valueOf(Instant.from(accessor).toEpochMilli());
    }

    @Override
    public String pattern() {
        return "epoch_millis";
    }

    @Override
    public DateFormatter parseDefaulting(Map<TemporalField, Long> fields) {
        return this;
    }

    @Override
    public Locale getLocale() {
        return Locale.ROOT;
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }
}

