/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import io.crate.common.CheckedFunction;
import io.crate.netty.EventLoopGroups;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateReplicaAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;

public final class NetworkModule {
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String HTTP_TYPE_KEY = "http.type";
    public static final String HTTP_TYPE_DEFAULT_KEY = "http.type.default";
    public static final String TRANSPORT_TYPE_DEFAULT_KEY = "transport.type.default";
    public static final Setting<String> TRANSPORT_DEFAULT_TYPE_SETTING = Setting.simpleString("transport.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_DEFAULT_TYPE_SETTING = Setting.simpleString("http.type.default", Setting.Property.NodeScope);
    public static final Setting<String> HTTP_TYPE_SETTING = Setting.simpleString("http.type", Setting.Property.NodeScope);
    public static final Setting<String> TRANSPORT_TYPE_SETTING = Setting.simpleString("transport.type", Setting.Property.NodeScope);
    private final Settings settings;
    private static final List<NamedWriteableRegistry.Entry> NAMED_WRITEABLES = new ArrayList<NamedWriteableRegistry.Entry>();
    private static final List<NamedXContentRegistry.Entry> NAMED_XCONTENTS = new ArrayList<NamedXContentRegistry.Entry>();
    private final Map<String, Supplier<Transport>> transportFactories = new HashMap<String, Supplier<Transport>>();
    private final Map<String, Supplier<HttpServerTransport>> transportHttpFactories = new HashMap<String, Supplier<HttpServerTransport>>();

    public NetworkModule(Settings settings, List<NetworkPlugin> plugins, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, EventLoopGroups eventLoopGroups, NodeClient nodeClient) {
        this.settings = settings;
        for (NetworkPlugin plugin : plugins) {
            Map<String, Supplier<HttpServerTransport>> httpTransportFactory = plugin.getHttpTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, xContentRegistry, networkService, eventLoopGroups, nodeClient);
            for (Map.Entry<String, Supplier<HttpServerTransport>> entry : httpTransportFactory.entrySet()) {
                this.registerHttpTransport(entry.getKey(), entry.getValue());
            }
            Map<String, Supplier<Transport>> transportFactory = plugin.getTransports(settings, threadPool, bigArrays, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, eventLoopGroups);
            for (Map.Entry<String, Supplier<Transport>> entry : transportFactory.entrySet()) {
                this.registerTransport(entry.getKey(), entry.getValue());
            }
        }
    }

    private void registerTransport(String key, Supplier<Transport> factory) {
        if (this.transportFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private void registerHttpTransport(String key, Supplier<HttpServerTransport> factory) {
        if (this.transportHttpFactories.putIfAbsent(key, factory) != null) {
            throw new IllegalArgumentException("transport for name: " + key + " is already registered");
        }
    }

    private static <T extends AllocationCommand> void registerAllocationCommand(Writeable.Reader<T> reader, CheckedFunction<XContentParser, T, IOException> parser, ParseField commandName) {
        NAMED_XCONTENTS.add(new NamedXContentRegistry.Entry(AllocationCommand.class, commandName, parser));
        NAMED_WRITEABLES.add(new NamedWriteableRegistry.Entry(AllocationCommand.class, commandName.getPreferredName(), reader));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.unmodifiableList(NAMED_WRITEABLES);
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Collections.unmodifiableList(NAMED_XCONTENTS);
    }

    public Supplier<HttpServerTransport> getHttpServerTransportSupplier() {
        String name = HTTP_TYPE_SETTING.exists(this.settings) ? HTTP_TYPE_SETTING.get(this.settings) : HTTP_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<HttpServerTransport> factory = this.transportHttpFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported http.type [" + name + "]");
        }
        return factory;
    }

    public Supplier<Transport> getTransportSupplier() {
        String name = TRANSPORT_TYPE_SETTING.exists(this.settings) ? TRANSPORT_TYPE_SETTING.get(this.settings) : TRANSPORT_DEFAULT_TYPE_SETTING.get(this.settings);
        Supplier<Transport> factory = this.transportFactories.get(name);
        if (factory == null) {
            throw new IllegalStateException("Unsupported transport.type [" + name + "]");
        }
        return factory;
    }

    static {
        NetworkModule.registerAllocationCommand(CancelAllocationCommand::new, CancelAllocationCommand::fromXContent, CancelAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(MoveAllocationCommand::new, MoveAllocationCommand::fromXContent, MoveAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateReplicaAllocationCommand::new, AllocateReplicaAllocationCommand::fromXContent, AllocateReplicaAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateEmptyPrimaryAllocationCommand::new, AllocateEmptyPrimaryAllocationCommand::fromXContent, AllocateEmptyPrimaryAllocationCommand.COMMAND_NAME_FIELD);
        NetworkModule.registerAllocationCommand(AllocateStalePrimaryAllocationCommand::new, AllocateStalePrimaryAllocationCommand::fromXContent, AllocateStalePrimaryAllocationCommand.COMMAND_NAME_FIELD);
    }
}

