/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import io.crate.common.SuppressForbidden;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;

public class Lucene {
    public static final String LATEST_CODEC = "Lucene87";
    public static final String SOFT_DELETES_FIELD = "__soft_deletes";
    public static final NamedAnalyzer STANDARD_ANALYZER = new NamedAnalyzer("_standard", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
    public static final NamedAnalyzer KEYWORD_ANALYZER = new NamedAnalyzer("_keyword", AnalyzerScope.GLOBAL, (Analyzer)new KeywordAnalyzer());

    public static Version parseVersion(@Nullable String version, Version defaultVersion, Logger logger) {
        if (version == null) {
            return defaultVersion;
        }
        try {
            return Version.parse((String)version);
        }
        catch (ParseException e) {
            logger.warn(() -> new ParameterizedMessage("no version match {}, default to {}", (Object)version, (Object)defaultVersion), (Throwable)e);
            return defaultVersion;
        }
    }

    public static SegmentInfos readSegmentInfos(Directory directory) throws IOException {
        return SegmentInfos.readLatestCommit((Directory)directory);
    }

    public static Iterable<String> files(SegmentInfos infos) throws IOException {
        ArrayList<Collection> list = new ArrayList<Collection>();
        list.add(Collections.singleton(infos.getSegmentsFileName()));
        for (SegmentCommitInfo info : infos) {
            list.add(info.files());
        }
        return Iterables.flatten(list);
    }

    public static int getNumDocs(SegmentInfos info) {
        int numDocs = 0;
        for (SegmentCommitInfo si : info) {
            numDocs += si.info.maxDoc() - si.getDelCount() - si.getSoftDelCount();
        }
        return numDocs;
    }

    public static SegmentInfos readSegmentInfos(IndexCommit commit) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)commit.getGeneration());
        return SegmentInfos.readCommit((Directory)commit.getDirectory(), (String)filename);
    }

    private static SegmentInfos readSegmentInfos(String segmentsFileName, Directory directory) throws IOException {
        return SegmentInfos.readCommit((Directory)directory, (String)segmentsFileName);
    }

    public static SegmentInfos pruneUnreferencedFiles(String segmentsFileName, Directory directory) throws IOException {
        SegmentInfos si = Lucene.readSegmentInfos(segmentsFileName, directory);
        try (Lock writeLock = directory.obtainLock("write.lock");){
            int foundSegmentFiles = 0;
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                ++foundSegmentFiles;
                if (file.equals(si.getSegmentsFileName())) continue;
                directory.deleteFile(file);
            }
            assert (SegmentInfos.getLastCommitSegmentsFileName((Directory)directory).equals(segmentsFileName));
            if (foundSegmentFiles == 0) {
                throw new IllegalStateException("no commit found in the directory");
            }
        }
        CommitPoint cp = new CommitPoint(si, directory);
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig((Analyzer)STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setIndexCommit((IndexCommit)cp).setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND));
        writer.close();
        return si;
    }

    public static IndexCommit getIndexCommit(SegmentInfos si, Directory directory) throws IOException {
        return new CommitPoint(si, directory);
    }

    public static void cleanLuceneIndex(Directory directory) throws IOException {
        try (Lock writeLock = directory.obtainLock("write.lock");){
            for (String file : directory.listAll()) {
                if (!file.startsWith("segments") && !file.equals("segments.gen")) continue;
                directory.deleteFile(file);
            }
        }
        IndexWriter writer = new IndexWriter(directory, new IndexWriterConfig((Analyzer)STANDARD_ANALYZER).setSoftDeletesField(SOFT_DELETES_FIELD).setMergePolicy(NoMergePolicy.INSTANCE).setCommitOnClose(false).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        writer.close();
    }

    public static void checkSegmentInfoIntegrity(final Directory directory) throws IOException {
        new SegmentInfos.FindSegmentsFile<Object>(directory){

            protected Object doBody(String segmentFileName) throws IOException {
                try (IndexInput input = directory.openInput(segmentFileName, IOContext.READ);){
                    CodecUtil.checksumEntireFile((IndexInput)input);
                }
                return null;
            }
        }.run();
    }

    private Lucene() {
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return DirectoryReader.indexExists((Directory)directory);
    }

    public static boolean isCorruptionException(Throwable t) {
        return ExceptionsHelper.unwrapCorruption(t) != null;
    }

    public static Version parseVersionLenient(String toParse, Version defaultValue) {
        return LenientParser.parse(toParse, defaultValue);
    }

    public static SegmentReader segmentReader(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            return (SegmentReader)reader;
        }
        if (reader instanceof FilterLeafReader) {
            FilterLeafReader fReader = (FilterLeafReader)reader;
            return Lucene.segmentReader(FilterLeafReader.unwrap((LeafReader)fReader));
        }
        if (reader instanceof FilterCodecReader) {
            FilterCodecReader fReader = (FilterCodecReader)reader;
            return Lucene.segmentReader((LeafReader)FilterCodecReader.unwrap((CodecReader)fReader));
        }
        throw new IllegalStateException("Can not extract segment reader from given index reader [" + reader + "]");
    }

    public static DirectoryReader wrapAllDocsLive(DirectoryReader in) throws IOException {
        return new DirectoryReaderWithAllLiveDocs(in);
    }

    private static int popCount(Bits bits) {
        assert (bits != null);
        int onBits = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            ++onBits;
        }
        return onBits;
    }

    public static NumericDocValuesField newSoftDeletesField() {
        return new NumericDocValuesField(SOFT_DELETES_FIELD, 1L);
    }

    private static final class CommitPoint
    extends IndexCommit {
        private String segmentsFileName;
        private final Collection<String> files;
        private final Directory dir;
        private final long generation;
        private final Map<String, String> userData;
        private final int segmentCount;

        private CommitPoint(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        public int getSegmentCount() {
            return this.segmentCount;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection<String> getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }

        public Map<String, String> getUserData() {
            return this.userData;
        }

        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }

    @SuppressForbidden(reason="Version#parseLeniently() used in a central place")
    private static final class LenientParser {
        private LenientParser() {
        }

        public static Version parse(String toParse, Version defaultValue) {
            if (Strings.hasLength(toParse)) {
                try {
                    return Version.parseLeniently((String)toParse);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }
    }

    private static final class DirectoryReaderWithAllLiveDocs
    extends FilterDirectoryReader {
        DirectoryReaderWithAllLiveDocs(DirectoryReader in) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader leaf) {
                    SegmentReader segmentReader = Lucene.segmentReader(leaf);
                    Bits hardLiveDocs = segmentReader.getHardLiveDocs();
                    if (hardLiveDocs == null) {
                        return new LeafReaderWithLiveDocs(leaf, null, leaf.maxDoc());
                    }
                    int numDocs = segmentReader.maxDoc() - segmentReader.getSegmentInfo().getDelCount();
                    assert (numDocs == Lucene.popCount(hardLiveDocs)) : numDocs + " != " + Lucene.popCount(hardLiveDocs);
                    return new LeafReaderWithLiveDocs((LeafReader)segmentReader, hardLiveDocs, numDocs);
                }
            });
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return Lucene.wrapAllDocsLive(in);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        static final class LeafReaderWithLiveDocs
        extends FilterLeafReader {
            final Bits liveDocs;
            final int numDocs;

            LeafReaderWithLiveDocs(LeafReader in, Bits liveDocs, int numDocs) {
                super(in);
                this.liveDocs = liveDocs;
                this.numDocs = numDocs;
            }

            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            public int numDocs() {
                return this.numDocs;
            }

            public IndexReader.CacheHelper getCoreCacheHelper() {
                return this.in.getCoreCacheHelper();
            }

            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        }
    }
}

