/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.WeakHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

class PrefixLogger
extends ExtendedLoggerWrapper {
    private static final WeakHashMap<String, Marker> MARKERS = new WeakHashMap();
    private final Marker marker;

    static int markersSize() {
        return MARKERS.size();
    }

    public String prefix() {
        return this.marker.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrefixLogger(ExtendedLogger logger, String name, String prefix) {
        super(logger, name, null);
        Marker actualMarker;
        String actualPrefix = prefix == null ? "" : prefix;
        WeakHashMap<String, Marker> weakHashMap = MARKERS;
        synchronized (weakHashMap) {
            Marker maybeMarker = MARKERS.get(actualPrefix);
            if (maybeMarker == null) {
                actualMarker = new MarkerManager.Log4jMarker(actualPrefix);
                MARKERS.put(new String(actualPrefix), actualMarker);
            } else {
                actualMarker = maybeMarker;
            }
        }
        this.marker = actualMarker;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        assert (marker == null);
        super.logMessage(fqcn, level, this.marker, message, t);
    }
}

