/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import io.crate.common.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;
    public static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    };

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        long l;
        block6: {
            block5: {
                Objects.requireNonNull(in, "No InputStream specified");
                Objects.requireNonNull(out, "No OutputStream specified");
                boolean success = false;
                try {
                    int bytesRead;
                    long byteCount = 0L;
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        byteCount += (long)bytesRead;
                    }
                    out.flush();
                    success = true;
                    l = byteCount;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in, out);
                    } else {
                        IOUtils.closeWhileHandlingException(in, out);
                    }
                    throw throwable;
                }
                IOUtils.close(in, out);
                break block6;
            }
            IOUtils.closeWhileHandlingException(in, out);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        int n;
        block6: {
            block5: {
                Objects.requireNonNull(in, "No Reader specified");
                Objects.requireNonNull(out, "No Writer specified");
                boolean success = false;
                try {
                    int bytesRead;
                    int byteCount = 0;
                    char[] buffer = new char[8192];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                        byteCount += bytesRead;
                    }
                    out.flush();
                    success = true;
                    n = byteCount;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in, out);
                    } else {
                        IOUtils.closeWhileHandlingException(in, out);
                    }
                    throw throwable;
                }
                IOUtils.close(in, out);
                break block6;
            }
            IOUtils.closeWhileHandlingException(in, out);
        }
        return n;
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, out);
        return out.toString();
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static BytesReference readFully(InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            BytesStreamOutput out = new BytesStreamOutput();
            Streams.copy(inputStream, out);
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
    }

    public static BytesStream flushOnCloseStream(BytesStream os) {
        return new FlushOnCloseOutputStream(os);
    }

    private static class FlushOnCloseOutputStream
    extends BytesStream {
        private final BytesStream delegate;

        private FlushOnCloseOutputStream(BytesStream bytesStreamOutput) {
            this.delegate = bytesStreamOutput;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public BytesReference bytes() {
            return this.delegate.bytes();
        }
    }
}

