/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import io.crate.common.SuppressForbidden;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

@SuppressForbidden(reason="Channel#read")
public final class Channels {
    private static final int READ_CHUNK_SIZE = 16384;
    private static final int WRITE_CHUNK_SIZE = 8192;

    private Channels() {
    }

    public static byte[] readFromFileChannel(FileChannel channel, long position, int length) throws IOException {
        byte[] res = new byte[length];
        Channels.readFromFileChannelWithEofException(channel, position, res, 0, length);
        return res;
    }

    public static void readFromFileChannelWithEofException(FileChannel channel, long channelPosition, byte[] dest, int destOffset, int length) throws IOException {
        int read = Channels.readFromFileChannel(channel, channelPosition, dest, destOffset, length);
        if (read < 0) {
            throw new EOFException("read past EOF. pos [" + channelPosition + "] length: [" + length + "] end: [" + channel.size() + "]");
        }
    }

    public static int readFromFileChannel(FileChannel channel, long channelPosition, byte[] dest, int destOffset, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(dest, destOffset, length);
        return Channels.readFromFileChannel(channel, channelPosition, buffer);
    }

    public static void readFromFileChannelWithEofException(FileChannel channel, long channelPosition, ByteBuffer dest) throws IOException {
        int read = Channels.readFromFileChannel(channel, channelPosition, dest);
        if (read < 0) {
            throw new EOFException("read past EOF. pos [" + channelPosition + "] length: [" + dest.limit() + "] end: [" + channel.size() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFromFileChannel(FileChannel channel, long channelPosition, ByteBuffer dest) throws IOException {
        if (dest.isDirect() || dest.remaining() < 16384) {
            return Channels.readSingleChunk(channel, channelPosition, dest);
        }
        int bytesRead = 0;
        int bytesToRead = dest.remaining();
        ByteBuffer tmpBuffer = dest.duplicate();
        try {
            while (dest.hasRemaining()) {
                tmpBuffer.limit(Math.min(dest.limit(), tmpBuffer.position() + 16384));
                int read = Channels.readSingleChunk(channel, channelPosition, tmpBuffer);
                if (read < 0) {
                    int n = read;
                    return n;
                }
                bytesRead += read;
                channelPosition += (long)read;
                dest.position(tmpBuffer.position());
            }
        }
        finally {
            dest.position(tmpBuffer.position());
        }
        assert (bytesRead == bytesToRead) : "failed to read an entire buffer but also didn't get an EOF (read [" + bytesRead + "] needed [" + bytesToRead + "]";
        return bytesRead;
    }

    private static int readSingleChunk(FileChannel channel, long channelPosition, ByteBuffer dest) throws IOException {
        int bytesRead = 0;
        while (dest.hasRemaining()) {
            int read = channel.read(dest, channelPosition);
            if (read < 0) {
                return read;
            }
            assert (read > 0) : "FileChannel.read with non zero-length bb.remaining() must always read at least one byte (FileChannel is in blocking mode, see spec of ReadableByteChannel)";
            bytesRead += read;
            channelPosition += (long)read;
        }
        return bytesRead;
    }

    public static void writeToChannel(byte[] source, WritableByteChannel channel) throws IOException {
        Channels.writeToChannel(source, 0, source.length, channel);
    }

    public static void writeToChannel(byte[] source, int offset, int length, WritableByteChannel channel) throws IOException {
        int toWrite = Math.min(length, 8192);
        ByteBuffer buffer = ByteBuffer.wrap(source, offset, toWrite);
        int written = channel.write(buffer);
        length -= written;
        while (length > 0) {
            toWrite = Math.min(length, 8192);
            buffer.limit(buffer.position() + toWrite);
            written = channel.write(buffer);
            length -= written;
        }
        assert (length == 0) : "wrote more then expected bytes (length=" + length + ")";
    }

    public static void writeToChannel(ByteBuffer byteBuffer, WritableByteChannel channel) throws IOException {
        if (byteBuffer.isDirect() || byteBuffer.remaining() <= 8192) {
            while (byteBuffer.hasRemaining()) {
                channel.write(byteBuffer);
            }
        } else {
            ByteBuffer tmpBuffer = byteBuffer.duplicate();
            try {
                while (byteBuffer.hasRemaining()) {
                    tmpBuffer.limit(Math.min(byteBuffer.limit(), tmpBuffer.position() + 8192));
                    while (tmpBuffer.hasRemaining()) {
                        channel.write(tmpBuffer);
                    }
                    byteBuffer.position(tmpBuffer.position());
                }
            }
            finally {
                byteBuffer.position(tmpBuffer.position());
            }
        }
    }
}

