/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import org.elasticsearch.common.util.ByteUtils;

public final class MurmurHash3
extends Enum<MurmurHash3> {
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    private static final int DEFAULT_SEED = 123;
    private static final /* synthetic */ MurmurHash3[] $VALUES;

    public static MurmurHash3[] values() {
        return (MurmurHash3[])$VALUES.clone();
    }

    public static MurmurHash3 valueOf(String name) {
        return Enum.valueOf(MurmurHash3.class, name);
    }

    protected static long fmix(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static long hash64(byte[] data, int length) {
        return MurmurHash3.hash64(data, length, 123);
    }

    public static long hash64(byte[] data, int length, int seed) {
        long hash = seed;
        int nblocks = length >> 3;
        for (int i = 0; i < nblocks; ++i) {
            int i8 = i << 3;
            long k = (long)data[i8] & 0xFFL | ((long)data[i8 + 1] & 0xFFL) << 8 | ((long)data[i8 + 2] & 0xFFL) << 16 | ((long)data[i8 + 3] & 0xFFL) << 24 | ((long)data[i8 + 4] & 0xFFL) << 32 | ((long)data[i8 + 5] & 0xFFL) << 40 | ((long)data[i8 + 6] & 0xFFL) << 48 | ((long)data[i8 + 7] & 0xFFL) << 56;
            k *= -8663945395140668459L;
            k = Long.rotateLeft(k, 31);
            hash ^= (k *= 5545529020109919103L);
            hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
        }
        long k1 = 0L;
        int tailStart = nblocks << 3;
        switch (length - tailStart) {
            case 7: {
                k1 ^= ((long)data[tailStart + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)data[tailStart + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)data[tailStart + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)data[tailStart + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)data[tailStart + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)data[tailStart + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)data[tailStart] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                hash ^= (k1 *= 5545529020109919103L);
            }
        }
        hash ^= (long)length;
        hash = MurmurHash3.fmix(hash);
        return hash;
    }

    public static Hash128 hash128(byte[] key, int offset, int length, long seed, Hash128 hash) {
        long h1 = seed;
        long h2 = seed;
        if (length >= 16) {
            int len16 = length & 0xFFFFFFF0;
            int end = offset + len16;
            for (int i = offset; i < end; i += 16) {
                long k1 = ByteUtils.readLongLE(key, i);
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
                h1 = Long.rotateLeft(h1, 27);
                h1 += h2;
                h1 = h1 * 5L + 1390208809L;
                long k2 = ByteUtils.readLongLE(key, i + 8);
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
                h2 = Long.rotateLeft(h2, 31);
                h2 += h1;
                h2 = h2 * 5L + 944331445L;
            }
            offset = end;
        }
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= ((long)key[offset + 14] & 0xFFL) << 48;
            }
            case 14: {
                k2 ^= ((long)key[offset + 13] & 0xFFL) << 40;
            }
            case 13: {
                k2 ^= ((long)key[offset + 12] & 0xFFL) << 32;
            }
            case 12: {
                k2 ^= ((long)key[offset + 11] & 0xFFL) << 24;
            }
            case 11: {
                k2 ^= ((long)key[offset + 10] & 0xFFL) << 16;
            }
            case 10: {
                k2 ^= ((long)key[offset + 9] & 0xFFL) << 8;
            }
            case 9: {
                k2 ^= ((long)key[offset + 8] & 0xFFL) << 0;
                k2 *= 5545529020109919103L;
                k2 = Long.rotateLeft(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= ((long)key[offset + 7] & 0xFFL) << 56;
            }
            case 7: {
                k1 ^= ((long)key[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                k1 ^= ((long)key[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                k1 ^= ((long)key[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                k1 ^= ((long)key[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                k1 ^= ((long)key[offset + 2] & 0xFFL) << 16;
            }
            case 2: {
                k1 ^= ((long)key[offset + 1] & 0xFFL) << 8;
            }
            case 1: {
                k1 ^= (long)key[offset] & 0xFFL;
                k1 *= -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash3.fmix(h1);
        h2 = MurmurHash3.fmix(h2);
        h1 += h2;
        hash.h1 = h1;
        hash.h2 = h2 += h1;
        return hash;
    }

    private static /* synthetic */ MurmurHash3[] $values() {
        return new MurmurHash3[0];
    }

    static {
        $VALUES = MurmurHash3.$values();
    }

    public static class Hash128 {
        public long h1;
        public long h2;
    }
}

