/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MessageDigests {
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = MessageDigests.createThreadLocalMessageDigest("MD5");
    private static final ThreadLocal<MessageDigest> SHA_1_DIGEST = MessageDigests.createThreadLocalMessageDigest("SHA-1");

    private static ThreadLocal<MessageDigest> createThreadLocalMessageDigest(String digest) {
        return ThreadLocal.withInitial(() -> {
            try {
                return MessageDigest.getInstance(digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("unexpected exception creating MessageDigest instance for [" + digest + "]", e);
            }
        });
    }

    public static MessageDigest md5() {
        return MessageDigests.get(MD5_DIGEST);
    }

    public static MessageDigest sha1() {
        return MessageDigests.get(SHA_1_DIGEST);
    }

    private static MessageDigest get(ThreadLocal<MessageDigest> messageDigest) {
        MessageDigest instance = messageDigest.get();
        instance.reset();
        return instance;
    }
}

