/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.parsers;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.GeometryCollectionBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.CoordinateNode;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.locationtech.jts.geom.Coordinate;

abstract class GeoJsonParser {
    GeoJsonParser() {
    }

    protected static ShapeBuilder parse(XContentParser parser, GeoShapeFieldMapper shapeMapper) throws IOException {
        Enum shapeType = null;
        DistanceUnit.Distance radius = null;
        CoordinateNode coordinateNode = null;
        GeometryCollectionBuilder geometryCollections = null;
        ShapeBuilder.Orientation requestedOrientation = shapeMapper == null ? ShapeBuilder.Orientation.RIGHT : shapeMapper.fieldType().orientation();
        Explicit<Boolean> coerce = shapeMapper == null ? GeoShapeFieldMapper.Defaults.COERCE : shapeMapper.coerce();
        Explicit<Boolean> ignoreZValue = shapeMapper == null ? GeoShapeFieldMapper.Defaults.IGNORE_Z_VALUE : shapeMapper.ignoreZValue();
        String malformedException = null;
        try {
            XContentParser.Token token;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = parser.currentName();
                if (ShapeParser.FIELD_TYPE.match(fieldName, parser.getDeprecationHandler())) {
                    parser.nextToken();
                    GeoShapeType type = GeoShapeType.forName(parser.text());
                    if (shapeType != null && !shapeType.equals((Object)type)) {
                        malformedException = ShapeParser.FIELD_TYPE + " already parsed as [" + (GeoShapeType)shapeType + "] cannot redefine as [" + type + "]";
                        continue;
                    }
                    shapeType = type;
                    continue;
                }
                if (ShapeParser.FIELD_COORDINATES.match(fieldName, parser.getDeprecationHandler())) {
                    parser.nextToken();
                    CoordinateNode tempNode = GeoJsonParser.parseCoordinates(parser, ignoreZValue.value());
                    if (coordinateNode != null && tempNode.numDimensions() != coordinateNode.numDimensions()) {
                        throw new ElasticsearchParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
                    }
                    coordinateNode = tempNode;
                    continue;
                }
                if (ShapeParser.FIELD_GEOMETRIES.match(fieldName, parser.getDeprecationHandler())) {
                    if (shapeType == null) {
                        shapeType = GeoShapeType.GEOMETRYCOLLECTION;
                    } else if (!shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
                        malformedException = "cannot have [" + ShapeParser.FIELD_GEOMETRIES + "] with type set to [" + (GeoShapeType)shapeType + "]";
                    }
                    parser.nextToken();
                    geometryCollections = GeoJsonParser.parseGeometries(parser, shapeMapper);
                    continue;
                }
                if (CircleBuilder.FIELD_RADIUS.match(fieldName, parser.getDeprecationHandler())) {
                    if (shapeType == null) {
                        shapeType = GeoShapeType.CIRCLE;
                    } else if (!shapeType.equals((Object)GeoShapeType.CIRCLE)) {
                        malformedException = "cannot have [" + CircleBuilder.FIELD_RADIUS + "] with type set to [" + (GeoShapeType)shapeType + "]";
                    }
                    parser.nextToken();
                    radius = DistanceUnit.Distance.parseDistance(parser.text());
                    continue;
                }
                if (ShapeParser.FIELD_ORIENTATION.match(fieldName, parser.getDeprecationHandler())) {
                    if (shapeType != null && !(shapeType.equals((Object)GeoShapeType.POLYGON) || shapeType.equals((Object)GeoShapeType.MULTIPOLYGON))) {
                        malformedException = "cannot have [" + ShapeParser.FIELD_ORIENTATION + "] with type set to [" + (GeoShapeType)shapeType + "]";
                    }
                    parser.nextToken();
                    requestedOrientation = ShapeBuilder.Orientation.fromString(parser.text());
                    continue;
                }
                parser.nextToken();
                parser.skipChildren();
            }
        }
        catch (Exception ex) {
            while (parser.currentToken() != XContentParser.Token.END_OBJECT && parser.currentToken() != null) {
                parser.nextToken();
                parser.skipChildren();
            }
            throw ex;
        }
        if (malformedException != null) {
            throw new ElasticsearchParseException(malformedException, new Object[0]);
        }
        if (shapeType == null) {
            throw new ElasticsearchParseException("shape type not included", new Object[0]);
        }
        if (coordinateNode == null && GeoShapeType.GEOMETRYCOLLECTION != shapeType) {
            throw new ElasticsearchParseException("coordinates not included", new Object[0]);
        }
        if (geometryCollections == null && GeoShapeType.GEOMETRYCOLLECTION == shapeType) {
            throw new ElasticsearchParseException("geometries not included", new Object[0]);
        }
        if (radius != null && GeoShapeType.CIRCLE != shapeType) {
            throw new ElasticsearchParseException("field [{}] is supported for [{}] only", new Object[]{CircleBuilder.FIELD_RADIUS, CircleBuilder.TYPE});
        }
        if (shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
            return geometryCollections;
        }
        return ((GeoShapeType)shapeType).getBuilder(coordinateNode, radius, requestedOrientation, coerce.value());
    }

    private static CoordinateNode parseCoordinates(XContentParser parser, boolean ignoreZValue) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.skipChildren();
            parser.nextToken();
            throw new ElasticsearchParseException("coordinates cannot be specified as objects", new Object[0]);
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            return new CoordinateNode(GeoJsonParser.parseCoordinate(parser, ignoreZValue));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            CoordinateNode node = GeoJsonParser.parseCoordinates(parser, ignoreZValue);
            if (!nodes.isEmpty() && ((CoordinateNode)nodes.get(0)).numDimensions() != node.numDimensions()) {
                throw new ElasticsearchParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
            }
            nodes.add(node);
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Coordinate parseCoordinate(XContentParser parser, boolean ignoreZValue) throws IOException {
        if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lon = parser.doubleValue();
        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lat = parser.doubleValue();
        XContentParser.Token token = parser.nextToken();
        double alt = Double.NaN;
        if (token == XContentParser.Token.VALUE_NUMBER) {
            alt = GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            throw new ElasticsearchParseException("geo coordinates greater than 3 dimensions are not supported", new Object[0]);
        }
        return new Coordinate(lon, lat, alt);
    }

    static GeometryCollectionBuilder parseGeometries(XContentParser parser, GeoShapeFieldMapper mapper) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("geometries must be an array of geojson objects", new Object[0]);
        }
        XContentParser.Token token = parser.nextToken();
        GeometryCollectionBuilder geometryCollection = new GeometryCollectionBuilder();
        while (token != XContentParser.Token.END_ARRAY) {
            ShapeBuilder shapeBuilder = ShapeParser.parse(parser);
            geometryCollection.shape(shapeBuilder);
            token = parser.nextToken();
        }
        return geometryCollection;
    }
}

