/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;

public final class GeoPoint
implements ToXContentFragment {
    private double lat;
    private double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint(GeoPoint template) {
        this(template.getLat(), template.getLon());
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        return this.resetFromString(value, false);
    }

    public GeoPoint resetFromString(String value, boolean ignoreZValue) {
        if (value.contains(",")) {
            String[] vals = value.split(",");
            if (vals.length > 3) {
                throw new ElasticsearchParseException("failed to parse [{}], expected 2 or 3 coordinates but found: [{}]", vals.length);
            }
            double lat = Double.parseDouble(vals[0].trim());
            double lon = Double.parseDouble(vals[1].trim());
            if (vals.length > 2) {
                GeoPoint.assertZValue(ignoreZValue, Double.parseDouble(vals[2].trim()));
            }
            return this.reset(lat, lon);
        }
        return this.resetFromGeoHash(value);
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = GeoHashUtils.decodeLongitude(hash);
        this.lat = GeoHashUtils.decodeLatitude(hash);
        return this;
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash;
        try {
            hash = GeoHashUtils.mortonEncode(geohash);
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchParseException(ex.getMessage(), (Throwable)ex, new Object[0]);
        }
        return this.reset(GeoHashUtils.decodeLatitude(hash), GeoHashUtils.decodeLongitude(hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public double lat() {
        return this.lat;
    }

    public double getLat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double getLon() {
        return this.lon;
    }

    public String geohash() {
        return GeoHashUtils.stringEncode(this.lon, this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        return result;
    }

    public String toString() {
        return this.lat + ", " + this.lon;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.latlon(this.lat, this.lon);
    }

    public static double assertZValue(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [{}] parameter is [{}]", zValue, GeoPointFieldMapper.Names.IGNORE_Z_VALUE, ignoreZValue);
        }
        return zValue;
    }
}

