/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Collection;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.BitUtil;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.MortonEncoder;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String BASE_32_STRING = new String(BASE_32);
    public static final int PRECISION = 12;
    public static final short BITS = 31;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    private static final double LON_SCALE = 5965232.355555556;
    private static final short MORTON_OFFSET = 2;
    private static final long MAX_LAT_BITS = 0x3FFFFFFFL;

    private GeoHashUtils() {
    }

    public static long encodeLatLon(double lat, double lon) {
        return MortonEncoder.encode(lat, lon) >>> 2;
    }

    private static long longEncode(String hash, int length) {
        int level = length - 1;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5;
            if (level < 0) break;
        }
        return l << 4 | (long)length;
    }

    public static long fromMorton(long morton, int level) {
        long mFlipped = BitUtil.flipFlop((long)morton);
        return (mFlipped >>>= (12 - level) * 5 + 2) << 4 | (long)level;
    }

    public static String stringEncode(long geoHashLong) {
        int level = (int)geoHashLong & 0xF;
        geoHashLong >>>= 4;
        char[] chars = new char[level];
        do {
            chars[--level] = BASE_32[(int)(geoHashLong & 0x1FL)];
            geoHashLong >>>= 5;
        } while (level > 0);
        return new String(chars);
    }

    public static final String stringEncode(double lon, double lat) {
        return GeoHashUtils.stringEncode(lon, lat, 12);
    }

    public static final String stringEncode(double lon, double lat, int level) {
        long ghLong = GeoHashUtils.fromMorton(GeoHashUtils.encodeLatLon(lat, lon), level);
        return GeoHashUtils.stringEncode(ghLong);
    }

    public static final long mortonEncode(String hash) {
        if (hash.isEmpty()) {
            throw new IllegalArgumentException("empty geohash");
        }
        int level = 11;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            if (b < 0L) {
                throw new IllegalArgumentException("unsupported symbol [" + c + "] in geohash [" + hash + "]");
            }
            l |= b << level-- * 5 + 2;
            if (level < 0) break;
        }
        return BitUtil.flipFlop((long)l);
    }

    public static final long mortonEncode(long geoHashLong) {
        int level = (int)(geoHashLong & 0xFL);
        short odd = (short)(level & 1);
        return BitUtil.flipFlop((long)(geoHashLong >>> 4 << odd << (12 - level) * 5 + (2 - odd)));
    }

    private static char encode(int x, int y) {
        return BASE_32[((x & 1) + (y & 1) * 2 + (x & 2) * 2 + (y & 2) * 4 + (x & 4) * 4) % 32];
    }

    public static Rectangle bbox(String geohash) {
        GeoPoint bottomLeft = GeoPoint.fromGeohash(geohash);
        int len = Math.min(12, geohash.length());
        long ghLong = GeoHashUtils.longEncode(geohash, len);
        long lon = BitUtil.deinterleave((long)((ghLong >>>= 4) >>> 1));
        long lat = BitUtil.deinterleave((long)ghLong);
        if (lat < 0x3FFFFFFFL) {
            GeoPoint topRight = GeoPoint.fromGeohash(BitUtil.interleave((int)((int)(lat + 1L)), (int)((int)(lon + 1L))) << 4 | (long)len);
            return new Rectangle(bottomLeft.lat(), topRight.lat(), bottomLeft.lon(), topRight.lon());
        }
        GeoPoint topRight = GeoPoint.fromGeohash(BitUtil.interleave((int)((int)lat), (int)((int)(lon + 1L))) << 4 | (long)len);
        return new Rectangle(bottomLeft.lat(), 90.0, bottomLeft.lon(), topRight.lon());
    }

    public static final String neighbor(String geohash, int level, int dx, int dy) {
        int ny;
        int cell = BASE_32_STRING.indexOf(geohash.charAt(level - 1));
        int x0 = cell & 1;
        int y0 = cell & 2;
        int x1 = cell & 4;
        int y1 = cell & 8;
        int x2 = cell & 0x10;
        int x = x0 + x1 / 2 + x2 / 4;
        int y = y0 / 2 + y1 / 4;
        if (level == 1) {
            if (dy < 0 && y == 0 || dy > 0 && y == 3) {
                return null;
            }
            return Character.toString(GeoHashUtils.encode(x + dx, y + dy));
        }
        int nx = level % 2 == 1 ? x + dx : x + dy;
        int n = ny = level % 2 == 1 ? y + dy : y + dx;
        if (nx >= 0 && nx <= 7 && ny >= 0 && ny <= 3) {
            return geohash.substring(0, level - 1) + GeoHashUtils.encode(nx, ny);
        }
        String neighbor = GeoHashUtils.neighbor(geohash, level - 1, dx, dy);
        return neighbor != null ? neighbor + GeoHashUtils.encode(nx, ny) : neighbor;
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, int length, E neighbors) {
        String north = GeoHashUtils.neighbor(geohash, length, 0, 1);
        if (north != null) {
            neighbors.add((String)GeoHashUtils.neighbor(north, length, -1, 0));
            neighbors.add((String)north);
            neighbors.add((String)GeoHashUtils.neighbor(north, length, 1, 0));
        }
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, -1, 0));
        neighbors.add((String)GeoHashUtils.neighbor(geohash, length, 1, 0));
        String south = GeoHashUtils.neighbor(geohash, length, 0, -1);
        if (south != null) {
            neighbors.add((String)GeoHashUtils.neighbor(south, length, -1, 0));
            neighbors.add((String)south);
            neighbors.add((String)GeoHashUtils.neighbor(south, length, 1, 0));
        }
        return (E)neighbors;
    }

    public static final double decodeLongitude(long hash) {
        return GeoHashUtils.unscaleLon(BitUtil.deinterleave((long)hash));
    }

    public static final double decodeLatitude(long hash) {
        return GeoHashUtils.unscaleLat(BitUtil.deinterleave((long)(hash >>> 1)));
    }

    private static double unscaleLon(long val) {
        return (double)val / 5965232.355555556 - 180.0;
    }

    private static double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 - 90.0;
    }
}

