/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url;

import io.crate.common.SuppressForbidden;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.url.URLBlobStore;

public class URLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public URLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    @Override
    public Map<String, BlobMetadata> listBlobs() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public Map<String, BlobContainer> children() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public void deleteBlob(String blobName) throws IOException {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    @Override
    public boolean blobExists(String blobName) {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @Override
    public InputStream readBlob(String name) throws IOException {
        try {
            return new BufferedInputStream(URLBlobContainer.getInputStream(new URL(this.path, name)), this.blobStore.bufferSizeInBytes());
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + name + "] blob not found");
        }
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
    private static InputStream getInputStream(URL url) throws IOException {
        try {
            return AccessController.doPrivileged(url::openStream);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

