/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.blobstore.BlobMetadata;
import org.elasticsearch.common.blobstore.BlobPath;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1);

    public InputStream readBlob(String var1) throws IOException;

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    default public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public void deleteBlob(String var1) throws IOException;

    public void delete() throws IOException;

    default public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        IOException ioe = null;
        for (String blobName : blobNames) {
            try {
                this.deleteBlob(blobName);
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    default public void deleteBlobIgnoringIfNotExists(String blobName) throws IOException {
        try {
            this.deleteBlob(blobName);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetadata> listBlobs() throws IOException;

    public Map<String, BlobMetadata> listBlobsByPrefix(String var1) throws IOException;
}

