/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import io.crate.common.SuppressForbidden;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public final class Randomness {
    private static final Method CURRENT_METHOD;
    private static final Method GET_RANDOM_METHOD;

    private Randomness() {
    }

    public static Random get(Settings settings, Setting<Long> setting) {
        if (setting.exists(settings)) {
            return new Random(setting.get(settings));
        }
        return Randomness.get();
    }

    public static Random get() {
        if (CURRENT_METHOD != null && GET_RANDOM_METHOD != null) {
            try {
                Object randomizedContext = CURRENT_METHOD.invoke(null, new Object[0]);
                return (Random)GET_RANDOM_METHOD.invoke(randomizedContext, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("running tests but failed to invoke RandomizedContext#getRandom", e);
            }
        }
        return Randomness.getWithoutSeed();
    }

    public static SecureRandom createSecure() {
        if (CURRENT_METHOD != null && GET_RANDOM_METHOD != null) {
            byte[] seed = new byte[16];
            Randomness.get().nextBytes(seed);
            return new SecureRandom(seed);
        }
        return new SecureRandom();
    }

    @SuppressForbidden(reason="ThreadLocalRandom is okay when not running tests")
    private static Random getWithoutSeed() {
        assert (CURRENT_METHOD == null && GET_RANDOM_METHOD == null) : "running under tests but tried to create non-reproducible random";
        return ThreadLocalRandom.current();
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, Randomness.get());
    }

    static {
        Method maybeGetRandomMethod;
        Method maybeCurrentMethod;
        try {
            Class<?> clazz = Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
            maybeCurrentMethod = clazz.getMethod("current", new Class[0]);
            maybeGetRandomMethod = clazz.getMethod("getRandom", new Class[0]);
        }
        catch (Exception e) {
            maybeCurrentMethod = null;
            maybeGetRandomMethod = null;
        }
        CURRENT_METHOD = maybeCurrentMethod;
        GET_RANDOM_METHOD = maybeGetRandomMethod;
    }
}

