/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.common.xcontent.DeprecationHandler;

public class ParseField {
    private final String name;
    private final String[] deprecatedNames;
    private String allReplacedWith = null;
    private final String[] allNames;
    private static final String[] EMPTY = new String[0];

    public ParseField(String name, String ... deprecatedNames) {
        this.name = name;
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = EMPTY;
        } else {
            HashSet set = new HashSet();
            Collections.addAll(set, deprecatedNames);
            this.deprecatedNames = set.toArray(new String[set.size()]);
        }
        HashSet<String> allNames = new HashSet<String>();
        allNames.add(name);
        Collections.addAll(allNames, this.deprecatedNames);
        this.allNames = allNames.toArray(new String[allNames.size()]);
    }

    public String getPreferredName() {
        return this.name;
    }

    public String[] getAllNamesIncludedDeprecated() {
        return this.allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNames) {
        return new ParseField(this.name, deprecatedNames);
    }

    public boolean match(String fieldName, DeprecationHandler deprecationHandler) {
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        if (this.allReplacedWith == null && fieldName.equals(this.name)) {
            return true;
        }
        for (String depName : this.deprecatedNames) {
            if (!fieldName.equals(depName)) continue;
            if (this.allReplacedWith == null) {
                deprecationHandler.usedDeprecatedName(fieldName, this.name);
            } else {
                deprecationHandler.usedDeprecatedField(fieldName, this.allReplacedWith);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public String getAllReplacedWith() {
        return this.allReplacedWith;
    }

    public String[] getDeprecatedNames() {
        return this.deprecatedNames;
    }
}

