/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class PendingClusterTask
implements Writeable {
    private final long insertOrder;
    private final Priority priority;
    private final String source;
    private final long timeInQueue;
    private final boolean executing;

    public PendingClusterTask(long insertOrder, Priority priority, String source, long timeInQueue, boolean executing) {
        assert (timeInQueue >= 0L) : "got a negative timeInQueue [" + timeInQueue + "]";
        assert (insertOrder >= 0L) : "got a negative insertOrder [" + insertOrder + "]";
        this.insertOrder = insertOrder;
        this.priority = priority;
        this.source = source;
        this.timeInQueue = timeInQueue;
        this.executing = executing;
    }

    public long getInsertOrder() {
        return this.insertOrder;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimeInQueueInMillis() {
        return this.timeInQueue;
    }

    public TimeValue getTimeInQueue() {
        return new TimeValue(this.getTimeInQueueInMillis());
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public PendingClusterTask(StreamInput in) throws IOException {
        this.insertOrder = in.readVLong();
        this.priority = Priority.readFrom(in);
        this.source = in.readString();
        this.timeInQueue = in.readLong();
        this.executing = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.insertOrder);
        Priority.writeTo(this.priority, out);
        out.writeString(this.source);
        out.writeLong(this.timeInQueue);
        out.writeBoolean(this.executing);
    }
}

