/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Locale;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class EnableAllocationDecider
extends AllocationDecider {
    public static final String NAME = "enable";
    public static final Setting<Allocation> CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING = new Setting<Allocation>("cluster.routing.allocation.enable", Allocation.ALL.toString(), Allocation::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Allocation> INDEX_ROUTING_ALLOCATION_ENABLE_SETTING = new Setting<Allocation>("index.routing.allocation.enable", Allocation.ALL.toString(), Allocation::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Rebalance> CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING = new Setting<Rebalance>("cluster.routing.rebalance.enable", Rebalance.ALL.toString(), Rebalance::parse, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Rebalance> INDEX_ROUTING_REBALANCE_ENABLE_SETTING = new Setting<Rebalance>("index.routing.rebalance.enable", Rebalance.ALL.toString(), Rebalance::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private volatile Rebalance enableRebalance;
    private volatile Allocation enableAllocation;

    public EnableAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.enableAllocation = CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.get(settings);
        this.enableRebalance = CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING, this::setEnableAllocation);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING, this::setEnableRebalance);
    }

    private void setEnableRebalance(Rebalance enableRebalance) {
        this.enableRebalance = enableRebalance;
    }

    private void setEnableAllocation(Allocation enableAllocation) {
        this.enableAllocation = enableAllocation;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        boolean usedIndexSetting;
        Allocation enable;
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "explicitly ignoring any disabling of allocation due to manual allocation commands via the reroute API", new Object[0]);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        if (INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.exists(indexMetadata.getSettings())) {
            enable = INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.get(indexMetadata.getSettings());
            usedIndexSetting = true;
        } else {
            enable = this.enableAllocation;
            usedIndexSetting = false;
        }
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all allocations are allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no allocations are allowed due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
            case NEW_PRIMARIES: {
                if (shardRouting.primary() && !shardRouting.active() && shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) {
                    return allocation.decision(Decision.YES, NAME, "new primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "non-new primary allocations are forbidden due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary allocations are allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica allocations are forbidden due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
        }
        throw new IllegalStateException("Unknown allocation option");
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation is explicitly ignoring any disabling of rebalancing", new Object[0]);
        }
        if (this.enableRebalance == Rebalance.NONE) {
            for (IndexMetadata indexMetaData : allocation.metadata()) {
                if (!INDEX_ROUTING_REBALANCE_ENABLE_SETTING.exists(indexMetaData.getSettings()) || INDEX_ROUTING_REBALANCE_ENABLE_SETTING.get(indexMetaData.getSettings()) == Rebalance.NONE) continue;
                return allocation.decision(Decision.YES, NAME, "rebalancing is permitted on one or more indices", new Object[0]);
            }
            return allocation.decision(Decision.NO, NAME, "no rebalancing is allowed due to %s", EnableAllocationDecider.setting(this.enableRebalance, false));
        }
        return allocation.decision(Decision.YES, NAME, "rebalancing is not globally disabled", new Object[0]);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        boolean usedIndexSetting;
        Rebalance enable;
        if (allocation.ignoreDisable()) {
            return allocation.decision(Decision.YES, NAME, "allocation is explicitly ignoring any disabling of rebalancing", new Object[0]);
        }
        Settings indexSettings = allocation.metadata().getIndexSafe(shardRouting.index()).getSettings();
        if (INDEX_ROUTING_REBALANCE_ENABLE_SETTING.exists(indexSettings)) {
            enable = INDEX_ROUTING_REBALANCE_ENABLE_SETTING.get(indexSettings);
            usedIndexSetting = true;
        } else {
            enable = this.enableRebalance;
            usedIndexSetting = false;
        }
        switch (enable) {
            case ALL: {
                return allocation.decision(Decision.YES, NAME, "all rebalancing is allowed", new Object[0]);
            }
            case NONE: {
                return allocation.decision(Decision.NO, NAME, "no rebalancing is allowed due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
            case PRIMARIES: {
                if (shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "primary rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "replica rebalancing is forbidden due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
            case REPLICAS: {
                if (!shardRouting.primary()) {
                    return allocation.decision(Decision.YES, NAME, "replica rebalancing is allowed", new Object[0]);
                }
                return allocation.decision(Decision.NO, NAME, "primary rebalancing is forbidden due to %s", EnableAllocationDecider.setting(enable, usedIndexSetting));
            }
        }
        throw new IllegalStateException("Unknown rebalance option");
    }

    private static String setting(Allocation allocation, boolean usedIndexSetting) {
        StringBuilder buf = new StringBuilder();
        if (usedIndexSetting) {
            buf.append("index setting [");
            buf.append(INDEX_ROUTING_ALLOCATION_ENABLE_SETTING.getKey());
        } else {
            buf.append("cluster setting [");
            buf.append(CLUSTER_ROUTING_ALLOCATION_ENABLE_SETTING.getKey());
        }
        buf.append("=").append(allocation.toString().toLowerCase(Locale.ROOT)).append("]");
        return buf.toString();
    }

    private static String setting(Rebalance rebalance, boolean usedIndexSetting) {
        StringBuilder buf = new StringBuilder();
        if (usedIndexSetting) {
            buf.append("index setting [");
            buf.append(INDEX_ROUTING_REBALANCE_ENABLE_SETTING.getKey());
        } else {
            buf.append("cluster setting [");
            buf.append(CLUSTER_ROUTING_REBALANCE_ENABLE_SETTING.getKey());
        }
        buf.append("=").append(rebalance.toString().toLowerCase(Locale.ROOT)).append("]");
        return buf.toString();
    }

    public static enum Allocation {
        NONE,
        NEW_PRIMARIES,
        PRIMARIES,
        ALL;


        public static Allocation parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Allocation.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal allocation.enable value [" + strValue + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Rebalance {
        NONE,
        PRIMARIES,
        REPLICAS,
        ALL;


        public static Rebalance parse(String strValue) {
            if (strValue == null) {
                return null;
            }
            strValue = strValue.toUpperCase(Locale.ROOT);
            try {
                return Rebalance.valueOf(strValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Illegal rebalance.enable value [" + strValue + "]");
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

