/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AllocateUnassignedDecision
extends AbstractAllocationDecision {
    public static final AllocateUnassignedDecision NOT_TAKEN = new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.NO_ATTEMPT, null, null, null, false, 0L, 0L);
    private static final Map<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> CACHED_DECISIONS;
    @Nullable
    private final UnassignedInfo.AllocationStatus allocationStatus;
    @Nullable
    private final String allocationId;
    private final boolean reuseStore;
    private final long remainingDelayInMillis;
    private final long configuredDelayInMillis;

    private AllocateUnassignedDecision(UnassignedInfo.AllocationStatus allocationStatus, DiscoveryNode assignedNode, String allocationId, List<NodeAllocationResult> nodeDecisions, boolean reuseStore, long remainingDelayInMillis, long configuredDelayInMillis) {
        super(assignedNode, nodeDecisions);
        assert (assignedNode != null || allocationStatus != null) : "a yes decision must have a node to assign the shard to";
        assert (allocationId == null || assignedNode != null) : "allocation id can only be null if the assigned node is null";
        this.allocationStatus = allocationStatus;
        this.allocationId = allocationId;
        this.reuseStore = reuseStore;
        this.remainingDelayInMillis = remainingDelayInMillis;
        this.configuredDelayInMillis = configuredDelayInMillis;
    }

    public AllocateUnassignedDecision(StreamInput in) throws IOException {
        super(in);
        this.allocationStatus = in.readOptionalWriteable(UnassignedInfo.AllocationStatus::readFrom);
        this.allocationId = in.readOptionalString();
        this.reuseStore = in.readBoolean();
        this.remainingDelayInMillis = in.readVLong();
        this.configuredDelayInMillis = in.readVLong();
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions) {
        return AllocateUnassignedDecision.no(allocationStatus, decisions, false);
    }

    public static AllocateUnassignedDecision delayed(long remainingDelay, long totalDelay, @Nullable List<NodeAllocationResult> decisions) {
        return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, decisions, false, remainingDelay, totalDelay);
    }

    public static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore) {
        return AllocateUnassignedDecision.no(allocationStatus, decisions, reuseStore, 0L, 0L);
    }

    private static AllocateUnassignedDecision no(UnassignedInfo.AllocationStatus allocationStatus, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore, long remainingDelay, long totalDelay) {
        if (decisions != null) {
            return new AllocateUnassignedDecision(allocationStatus, null, null, decisions, reuseStore, remainingDelay, totalDelay);
        }
        return AllocateUnassignedDecision.getCachedDecision(allocationStatus);
    }

    public static AllocateUnassignedDecision throttle(@Nullable List<NodeAllocationResult> decisions) {
        if (decisions != null) {
            return new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, null, null, decisions, false, 0L, 0L);
        }
        return AllocateUnassignedDecision.getCachedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED);
    }

    public static AllocateUnassignedDecision yes(DiscoveryNode assignedNode, @Nullable String allocationId, @Nullable List<NodeAllocationResult> decisions, boolean reuseStore) {
        return new AllocateUnassignedDecision(null, assignedNode, allocationId, decisions, reuseStore, 0L, 0L);
    }

    public static AllocateUnassignedDecision fromDecision(Decision decision, @Nullable DiscoveryNode assignedNode, @Nullable List<NodeAllocationResult> nodeDecisions) {
        Decision.Type decisionType = decision.type();
        UnassignedInfo.AllocationStatus allocationStatus = decisionType != Decision.Type.YES ? UnassignedInfo.AllocationStatus.fromDecision(decisionType) : null;
        return new AllocateUnassignedDecision(allocationStatus, assignedNode, null, nodeDecisions, false, 0L, 0L);
    }

    private static AllocateUnassignedDecision getCachedDecision(UnassignedInfo.AllocationStatus allocationStatus) {
        AllocateUnassignedDecision decision = CACHED_DECISIONS.get(allocationStatus);
        return Objects.requireNonNull(decision, "precomputed decision not found for " + allocationStatus);
    }

    @Override
    public boolean isDecisionTaken() {
        return this.allocationStatus != UnassignedInfo.AllocationStatus.NO_ATTEMPT;
    }

    public AllocationDecision getAllocationDecision() {
        this.checkDecisionState();
        return AllocationDecision.fromAllocationStatus(this.allocationStatus);
    }

    @Nullable
    public UnassignedInfo.AllocationStatus getAllocationStatus() {
        this.checkDecisionState();
        return this.allocationStatus;
    }

    @Nullable
    public String getAllocationId() {
        this.checkDecisionState();
        return this.allocationId;
    }

    @Override
    public String getExplanation() {
        this.checkDecisionState();
        AllocationDecision allocationDecision = this.getAllocationDecision();
        if (allocationDecision == AllocationDecision.YES) {
            return "can allocate the shard";
        }
        if (allocationDecision == AllocationDecision.THROTTLED) {
            return "allocation temporarily throttled";
        }
        if (allocationDecision == AllocationDecision.AWAITING_INFO) {
            return "cannot allocate because information about existing shard data is still being retrieved from some of the nodes";
        }
        if (allocationDecision == AllocationDecision.NO_VALID_SHARD_COPY) {
            if (this.hasNodeWithStaleOrCorruptShard()) {
                return "cannot allocate because all found copies of the shard are either stale or corrupt";
            }
            return "cannot allocate because a previous copy of the primary shard existed but can no longer be found on the nodes in the cluster";
        }
        if (allocationDecision == AllocationDecision.ALLOCATION_DELAYED) {
            return "cannot allocate because the cluster is still waiting " + TimeValue.timeValueMillis(this.remainingDelayInMillis) + " for the departed node holding a replica to rejoin" + (this.atLeastOneNodeWithYesDecision() ? ", despite being allowed to allocate the shard to at least one other node" : "");
        }
        assert (allocationDecision == AllocationDecision.NO);
        if (this.reuseStore) {
            return "cannot allocate because allocation is not permitted to any of the nodes that hold an in-sync shard copy";
        }
        return "cannot allocate because allocation is not permitted to any of the nodes";
    }

    private boolean hasNodeWithStaleOrCorruptShard() {
        return this.getNodeDecisions() != null && this.getNodeDecisions().stream().anyMatch(result -> result.getShardStoreInfo() != null && (result.getShardStoreInfo().getAllocationId() != null || result.getShardStoreInfo().getStoreException() != null));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.checkDecisionState();
        builder.field("can_allocate", this.getAllocationDecision());
        builder.field("allocate_explanation", this.getExplanation());
        if (this.targetNode != null) {
            builder.startObject("target_node");
            AllocateUnassignedDecision.discoveryNodeToXContent(this.targetNode, true, builder);
            builder.endObject();
        }
        if (this.allocationId != null) {
            builder.field("allocation_id", this.allocationId);
        }
        if (this.allocationStatus == UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION) {
            builder.humanReadableField("configured_delay_in_millis", "configured_delay", TimeValue.timeValueMillis(this.configuredDelayInMillis));
            builder.humanReadableField("remaining_delay_in_millis", "remaining_delay", TimeValue.timeValueMillis(this.remainingDelayInMillis));
        }
        this.nodeDecisionsToXContent(this.nodeDecisions, builder, params);
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.allocationStatus);
        out.writeOptionalString(this.allocationId);
        out.writeBoolean(this.reuseStore);
        out.writeVLong(this.remainingDelayInMillis);
        out.writeVLong(this.configuredDelayInMillis);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof AllocateUnassignedDecision)) {
            return false;
        }
        AllocateUnassignedDecision that = (AllocateUnassignedDecision)other;
        return Objects.equals(this.allocationStatus, that.allocationStatus) && Objects.equals(this.allocationId, that.allocationId) && this.reuseStore == that.reuseStore && this.configuredDelayInMillis == that.configuredDelayInMillis && this.remainingDelayInMillis == that.remainingDelayInMillis;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.allocationStatus, this.allocationId, this.reuseStore, this.configuredDelayInMillis, this.remainingDelayInMillis);
    }

    static {
        EnumMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision> cachedDecisions = new EnumMap<UnassignedInfo.AllocationStatus, AllocateUnassignedDecision>(UnassignedInfo.AllocationStatus.class);
        cachedDecisions.put(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_NO, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_NO, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, null, null, null, false, 0L, 0L));
        cachedDecisions.put(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, new AllocateUnassignedDecision(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, null, null, null, false, 0L, 0L));
        CACHED_DECISIONS = Collections.unmodifiableMap(cachedDecisions);
    }
}

