/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public final class ShardRouting
implements Writeable,
ToXContentObject {
    public static final long UNAVAILABLE_EXPECTED_SHARD_SIZE = -1L;
    private final ShardId shardId;
    private final String currentNodeId;
    private final String relocatingNodeId;
    private final boolean primary;
    private final ShardRoutingState state;
    private final RecoverySource recoverySource;
    private final UnassignedInfo unassignedInfo;
    private final AllocationId allocationId;
    private final transient List<ShardRouting> asList;
    private final long expectedShardSize;
    @Nullable
    private final ShardRouting targetRelocatingShard;
    private int hashCode;

    ShardRouting(ShardId shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, RecoverySource recoverySource, UnassignedInfo unassignedInfo, AllocationId allocationId, long expectedShardSize) {
        this.shardId = shardId;
        this.currentNodeId = currentNodeId;
        this.relocatingNodeId = relocatingNodeId;
        this.primary = primary;
        this.state = state;
        this.recoverySource = recoverySource;
        this.unassignedInfo = unassignedInfo;
        this.allocationId = allocationId;
        this.expectedShardSize = expectedShardSize;
        this.targetRelocatingShard = this.initializeTargetRelocatingShard();
        this.asList = Collections.singletonList(this);
        assert (expectedShardSize == -1L || state == ShardRoutingState.INITIALIZING || state == ShardRoutingState.RELOCATING) : expectedShardSize + " state: " + state;
        assert (expectedShardSize >= 0L || state != ShardRoutingState.INITIALIZING || state != ShardRoutingState.RELOCATING) : expectedShardSize + " state: " + state;
        assert (state != ShardRoutingState.UNASSIGNED || unassignedInfo != null) : "unassigned shard must be created with meta";
        assert ((state == ShardRoutingState.UNASSIGNED || state == ShardRoutingState.INITIALIZING) == (recoverySource != null)) : "recovery source only available on unassigned or initializing shard but was " + state;
        assert (recoverySource == null || recoverySource == RecoverySource.PeerRecoverySource.INSTANCE || primary) : "replica shards always recover from primary";
        assert (currentNodeId == null == (state == ShardRoutingState.UNASSIGNED)) : "unassigned shard must not be assigned to a node " + this;
    }

    @Nullable
    private ShardRouting initializeTargetRelocatingShard() {
        if (this.state == ShardRoutingState.RELOCATING) {
            return new ShardRouting(this.shardId, this.relocatingNodeId, this.currentNodeId, this.primary, ShardRoutingState.INITIALIZING, RecoverySource.PeerRecoverySource.INSTANCE, this.unassignedInfo, AllocationId.newTargetRelocation(this.allocationId), this.expectedShardSize);
        }
        return null;
    }

    public static ShardRouting newUnassigned(ShardId shardId, boolean primary, RecoverySource recoverySource, UnassignedInfo unassignedInfo) {
        return new ShardRouting(shardId, null, null, primary, ShardRoutingState.UNASSIGNED, recoverySource, unassignedInfo, null, -1L);
    }

    public Index index() {
        return this.shardId.getIndex();
    }

    public String getIndexName() {
        return this.shardId.getIndexName();
    }

    public int id() {
        return this.shardId.id();
    }

    public int getId() {
        return this.id();
    }

    public boolean unassigned() {
        return this.state == ShardRoutingState.UNASSIGNED;
    }

    public boolean initializing() {
        return this.state == ShardRoutingState.INITIALIZING;
    }

    public boolean active() {
        return this.started() || this.relocating();
    }

    public boolean started() {
        return this.state == ShardRoutingState.STARTED;
    }

    public boolean relocating() {
        return this.state == ShardRoutingState.RELOCATING;
    }

    public boolean assignedToNode() {
        return this.currentNodeId != null;
    }

    public String currentNodeId() {
        return this.currentNodeId;
    }

    public String relocatingNodeId() {
        return this.relocatingNodeId;
    }

    public ShardRouting getTargetRelocatingShard() {
        assert (this.relocating());
        return this.targetRelocatingShard;
    }

    @Nullable
    public UnassignedInfo unassignedInfo() {
        return this.unassignedInfo;
    }

    @Nullable
    public AllocationId allocationId() {
        return this.allocationId;
    }

    public boolean primary() {
        return this.primary;
    }

    public ShardRoutingState state() {
        return this.state;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.asList);
    }

    public ShardRouting(ShardId shardId, StreamInput in) throws IOException {
        this.shardId = shardId;
        this.currentNodeId = in.readOptionalString();
        this.relocatingNodeId = in.readOptionalString();
        this.primary = in.readBoolean();
        this.state = ShardRoutingState.fromValue(in.readByte());
        this.recoverySource = this.state == ShardRoutingState.UNASSIGNED || this.state == ShardRoutingState.INITIALIZING ? RecoverySource.readFrom(in) : null;
        this.unassignedInfo = in.readOptionalWriteable(UnassignedInfo::new);
        this.allocationId = in.readOptionalWriteable(AllocationId::new);
        long shardSize = this.state == ShardRoutingState.RELOCATING || this.state == ShardRoutingState.INITIALIZING ? in.readLong() : -1L;
        this.expectedShardSize = shardSize;
        this.asList = Collections.singletonList(this);
        this.targetRelocatingShard = this.initializeTargetRelocatingShard();
    }

    public ShardRouting(StreamInput in) throws IOException {
        this(new ShardId(in), in);
    }

    public void writeToThin(StreamOutput out) throws IOException {
        out.writeOptionalString(this.currentNodeId);
        out.writeOptionalString(this.relocatingNodeId);
        out.writeBoolean(this.primary);
        out.writeByte(this.state.value());
        if (this.state == ShardRoutingState.UNASSIGNED || this.state == ShardRoutingState.INITIALIZING) {
            this.recoverySource.writeTo(out);
        }
        out.writeOptionalWriteable(this.unassignedInfo);
        out.writeOptionalWriteable(this.allocationId);
        if (this.state == ShardRoutingState.RELOCATING || this.state == ShardRoutingState.INITIALIZING) {
            out.writeLong(this.expectedShardSize);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        this.writeToThin(out);
    }

    public ShardRouting updateUnassigned(UnassignedInfo unassignedInfo, RecoverySource recoverySource) {
        assert (this.unassignedInfo != null) : "can only update unassign info if they are already set";
        assert (this.unassignedInfo.isDelayed() || !unassignedInfo.isDelayed()) : "cannot transition from non-delayed to delayed";
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, this.primary, this.state, recoverySource, unassignedInfo, this.allocationId, this.expectedShardSize);
    }

    public ShardRouting moveToUnassigned(UnassignedInfo unassignedInfo) {
        assert (this.state != ShardRoutingState.UNASSIGNED) : this;
        RecoverySource recoverySource = this.active() ? (this.primary() ? RecoverySource.ExistingStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE) : this.recoverySource();
        return new ShardRouting(this.shardId, null, null, this.primary, ShardRoutingState.UNASSIGNED, recoverySource, unassignedInfo, null, -1L);
    }

    public ShardRouting initialize(String nodeId, @Nullable String existingAllocationId, long expectedShardSize) {
        assert (this.state == ShardRoutingState.UNASSIGNED) : this;
        assert (this.relocatingNodeId == null) : this;
        AllocationId allocationId = existingAllocationId == null ? AllocationId.newInitializing() : AllocationId.newInitializing(existingAllocationId);
        return new ShardRouting(this.shardId, nodeId, null, this.primary, ShardRoutingState.INITIALIZING, this.recoverySource, this.unassignedInfo, allocationId, expectedShardSize);
    }

    public ShardRouting relocate(String relocatingNodeId, long expectedShardSize) {
        assert (this.state == ShardRoutingState.STARTED) : "current shard has to be started in order to be relocated " + this;
        return new ShardRouting(this.shardId, this.currentNodeId, relocatingNodeId, this.primary, ShardRoutingState.RELOCATING, this.recoverySource, null, AllocationId.newRelocation(this.allocationId), expectedShardSize);
    }

    public ShardRouting cancelRelocation() {
        assert (this.state == ShardRoutingState.RELOCATING) : this;
        assert (this.assignedToNode()) : this;
        assert (this.relocatingNodeId != null) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.STARTED, this.recoverySource, null, AllocationId.cancelRelocation(this.allocationId), -1L);
    }

    public ShardRouting removeRelocationSource() {
        assert (!this.primary) : this;
        assert (this.state == ShardRoutingState.INITIALIZING) : this;
        assert (this.assignedToNode()) : this;
        assert (this.relocatingNodeId != null) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, this.state, this.recoverySource, this.unassignedInfo, AllocationId.finishRelocation(this.allocationId), this.expectedShardSize);
    }

    public ShardRouting reinitializeReplicaShard() {
        assert (this.state == ShardRoutingState.INITIALIZING) : this;
        assert (!this.primary) : this;
        assert (!this.isRelocationTarget()) : this;
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.INITIALIZING, this.recoverySource, this.unassignedInfo, AllocationId.newInitializing(), this.expectedShardSize);
    }

    public ShardRouting moveToStarted() {
        assert (this.state == ShardRoutingState.INITIALIZING) : "expected an initializing shard " + this;
        AllocationId allocationId = this.allocationId;
        if (allocationId.getRelocationId() != null) {
            allocationId = AllocationId.finishRelocation(allocationId);
        }
        return new ShardRouting(this.shardId, this.currentNodeId, null, this.primary, ShardRoutingState.STARTED, null, null, allocationId, -1L);
    }

    public ShardRouting moveActiveReplicaToPrimary() {
        assert (this.active()) : "expected an active shard " + this;
        if (this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to primary");
        }
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, true, this.state, this.recoverySource, this.unassignedInfo, this.allocationId, this.expectedShardSize);
    }

    public ShardRouting moveUnassignedFromPrimary() {
        assert (this.state == ShardRoutingState.UNASSIGNED) : "expected an unassigned shard " + this;
        if (!this.primary) {
            throw new IllegalShardRoutingStateException(this, "Not primary, can't move to replica");
        }
        return new ShardRouting(this.shardId, this.currentNodeId, this.relocatingNodeId, false, this.state, RecoverySource.PeerRecoverySource.INSTANCE, this.unassignedInfo, this.allocationId, this.expectedShardSize);
    }

    public boolean isSameAllocation(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.allocationId.getId().equals(other.allocationId.getId());
        assert (!b || this.currentNodeId.equals(other.currentNodeId)) : "ShardRoutings have the same allocation id but not the same node. This [" + this + "], other [" + other + "]";
        return b;
    }

    public boolean isRelocationTarget() {
        return this.state == ShardRoutingState.INITIALIZING && this.relocatingNodeId != null;
    }

    public boolean isRelocationTargetOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && this.state == ShardRoutingState.INITIALIZING && this.allocationId.getId().equals(other.allocationId.getRelocationId());
        assert (!b || other.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation target but the source shard state isn't relocating. This [" + this + "], other [" + other + "]";
        assert (!b || other.allocationId.getId().equals(this.allocationId.getRelocationId())) : "ShardRouting is a relocation target but the source id isn't equal to source's allocationId.getRelocationId. This [" + this + "], other [" + other + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation target but source current node id isn't equal to target relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation target but current node id isn't equal to source relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || this.shardId.equals(other.shardId)) : "ShardRouting is a relocation target but both indexRoutings are not of the same shard id. This [" + this + "], other [" + other + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation target but primary flag is different. This [" + this + "], target [" + other + "]";
        return b;
    }

    public boolean isRelocationSourceOf(ShardRouting other) {
        boolean b;
        boolean bl = b = this.allocationId != null && other.allocationId != null && other.state == ShardRoutingState.INITIALIZING && other.allocationId.getId().equals(this.allocationId.getRelocationId());
        assert (!b || this.state == ShardRoutingState.RELOCATING) : "ShardRouting is a relocation source but shard state isn't relocating. This [" + this + "], other [" + other + "]";
        assert (!b || this.allocationId.getId().equals(other.allocationId.getRelocationId())) : "ShardRouting is a relocation source but the allocation id isn't equal to other.allocationId.getRelocationId. This [" + this + "], other [" + other + "]";
        assert (!b || this.currentNodeId().equals(other.relocatingNodeId)) : "ShardRouting is a relocation source but current node isn't equal to other's relocating node. This [" + this + "], other [" + other + "]";
        assert (!b || other.currentNodeId().equals(this.relocatingNodeId)) : "ShardRouting is a relocation source but relocating node isn't equal to other's current node. This [" + this + "], other [" + other + "]";
        assert (!b || this.shardId.equals(other.shardId)) : "ShardRouting is a relocation source but both indexRoutings are not of the same shard. This [" + this + "], target [" + other + "]";
        assert (!b || this.primary == other.primary) : "ShardRouting is a relocation source but primary flag is different. This [" + this + "], target [" + other + "]";
        return b;
    }

    public boolean equalsIgnoringMetadata(ShardRouting other) {
        if (this.primary != other.primary) {
            return false;
        }
        if (this.shardId != null ? !this.shardId.equals(other.shardId) : other.shardId != null) {
            return false;
        }
        if (this.currentNodeId != null ? !this.currentNodeId.equals(other.currentNodeId) : other.currentNodeId != null) {
            return false;
        }
        if (this.relocatingNodeId != null ? !this.relocatingNodeId.equals(other.relocatingNodeId) : other.relocatingNodeId != null) {
            return false;
        }
        if (this.allocationId != null ? !this.allocationId.equals(other.allocationId) : other.allocationId != null) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return !(this.recoverySource != null ? !this.recoverySource.equals(other.recoverySource) : other.recoverySource != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ShardRouting)) {
            return false;
        }
        ShardRouting that = (ShardRouting)o;
        if (this.unassignedInfo != null ? !this.unassignedInfo.equals(that.unassignedInfo) : that.unassignedInfo != null) {
            return false;
        }
        return this.equalsIgnoringMetadata(that);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            h = this.shardId.hashCode();
            h = 31 * h + (this.currentNodeId != null ? this.currentNodeId.hashCode() : 0);
            h = 31 * h + (this.relocatingNodeId != null ? this.relocatingNodeId.hashCode() : 0);
            h = 31 * h + (this.primary ? 1 : 0);
            h = 31 * h + (this.state != null ? this.state.hashCode() : 0);
            h = 31 * h + (this.recoverySource != null ? this.recoverySource.hashCode() : 0);
            h = 31 * h + (this.allocationId != null ? this.allocationId.hashCode() : 0);
            this.hashCode = h = 31 * h + (this.unassignedInfo != null ? this.unassignedInfo.hashCode() : 0);
        }
        return h;
    }

    public String toString() {
        return this.shortSummary();
    }

    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.shardId.getIndexName()).append(']').append('[').append(this.shardId.getId()).append(']');
        sb.append(", node[").append(this.currentNodeId).append("], ");
        if (this.relocatingNodeId != null) {
            sb.append("relocating [").append(this.relocatingNodeId).append("], ");
        }
        if (this.primary) {
            sb.append("[P]");
        } else {
            sb.append("[R]");
        }
        if (this.recoverySource != null) {
            sb.append(", recovery_source[").append(this.recoverySource).append("]");
        }
        sb.append(", s[").append((Object)this.state).append("]");
        if (this.allocationId != null) {
            sb.append(", a").append(this.allocationId);
        }
        if (this.unassignedInfo != null) {
            sb.append(", ").append(this.unassignedInfo.toString());
        }
        if (this.expectedShardSize != -1L) {
            sb.append(", expected_shard_size[").append(this.expectedShardSize).append("]");
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("state", (Object)this.state()).field("primary", this.primary()).field("node", this.currentNodeId()).field("relocating_node", this.relocatingNodeId()).field("shard", this.id()).field("index", this.getIndexName());
        if (this.expectedShardSize != -1L) {
            builder.field("expected_shard_size_in_bytes", this.expectedShardSize);
        }
        if (this.recoverySource != null) {
            builder.field("recovery_source", this.recoverySource);
        }
        if (this.allocationId != null) {
            builder.field("allocation_id");
            this.allocationId.toXContent(builder, params);
        }
        if (this.unassignedInfo != null) {
            this.unassignedInfo.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public long getExpectedShardSize() {
        return this.expectedShardSize;
    }

    @Nullable
    public RecoverySource recoverySource() {
        return this.recoverySource;
    }
}

