/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.snapshots.Snapshot;

public abstract class RecoverySource
implements Writeable,
ToXContentObject {
    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", (Object)this.getType());
        this.addAdditionalFields(builder, params);
        return builder.endObject();
    }

    public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static RecoverySource readFrom(StreamInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case EMPTY_STORE: {
                return EmptyStoreRecoverySource.INSTANCE;
            }
            case EXISTING_STORE: {
                return new ExistingStoreRecoverySource(in);
            }
            case PEER: {
                return PeerRecoverySource.INSTANCE;
            }
            case SNAPSHOT: {
                return new SnapshotRecoverySource(in);
            }
            case LOCAL_SHARDS: {
                return LocalShardsRecoverySource.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unknown recovery type: " + type.name());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.getType().ordinal());
        this.writeAdditionalFields(out);
    }

    protected void writeAdditionalFields(StreamOutput out) throws IOException {
    }

    public abstract Type getType();

    public boolean shouldBootstrapNewHistoryUUID() {
        return false;
    }

    public boolean expectEmptyRetentionLeases() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecoverySource that = (RecoverySource)o;
        return this.getType() == that.getType();
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public static enum Type {
        EMPTY_STORE,
        EXISTING_STORE,
        PEER,
        SNAPSHOT,
        LOCAL_SHARDS;

    }

    public static final class EmptyStoreRecoverySource
    extends RecoverySource {
        public static final EmptyStoreRecoverySource INSTANCE = new EmptyStoreRecoverySource();

        @Override
        public Type getType() {
            return Type.EMPTY_STORE;
        }

        public String toString() {
            return "new shard recovery";
        }
    }

    public static final class ExistingStoreRecoverySource
    extends RecoverySource {
        public static final String FORCED_ALLOCATION_ID = "_forced_allocation_";
        public static final ExistingStoreRecoverySource INSTANCE = new ExistingStoreRecoverySource(false);
        public static final ExistingStoreRecoverySource FORCE_STALE_PRIMARY_INSTANCE = new ExistingStoreRecoverySource(true);
        private final boolean bootstrapNewHistoryUUID;

        private ExistingStoreRecoverySource(boolean bootstrapNewHistoryUUID) {
            this.bootstrapNewHistoryUUID = bootstrapNewHistoryUUID;
        }

        private ExistingStoreRecoverySource(StreamInput in) throws IOException {
            this.bootstrapNewHistoryUUID = in.readBoolean();
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("bootstrap_new_history_uuid", this.bootstrapNewHistoryUUID);
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            out.writeBoolean(this.bootstrapNewHistoryUUID);
        }

        @Override
        public boolean shouldBootstrapNewHistoryUUID() {
            return this.bootstrapNewHistoryUUID;
        }

        @Override
        public Type getType() {
            return Type.EXISTING_STORE;
        }

        public String toString() {
            return "existing store recovery; bootstrap_history_uuid=" + this.bootstrapNewHistoryUUID;
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return this.bootstrapNewHistoryUUID;
        }
    }

    public static class PeerRecoverySource
    extends RecoverySource {
        public static final PeerRecoverySource INSTANCE = new PeerRecoverySource();

        private PeerRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.PEER;
        }

        public String toString() {
            return "peer recovery";
        }

        @Override
        public boolean expectEmptyRetentionLeases() {
            return false;
        }
    }

    public static class SnapshotRecoverySource
    extends RecoverySource {
        private final String restoreUUID;
        private final Snapshot snapshot;
        private final String index;
        private final Version version;

        public SnapshotRecoverySource(String restoreUUID, Snapshot snapshot, Version version, String index) {
            this.restoreUUID = restoreUUID;
            this.snapshot = Objects.requireNonNull(snapshot);
            this.version = Objects.requireNonNull(version);
            this.index = Objects.requireNonNull(index);
        }

        SnapshotRecoverySource(StreamInput in) throws IOException {
            this.restoreUUID = in.getVersion().onOrAfter(Version.V_4_3_0) ? in.readString() : RestoreInProgress.BWC_UUID;
            this.snapshot = new Snapshot(in);
            this.version = Version.readVersion(in);
            this.index = in.readString();
        }

        public String restoreUUID() {
            return this.restoreUUID;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public String index() {
            return this.index;
        }

        public Version version() {
            return this.version;
        }

        @Override
        protected void writeAdditionalFields(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_4_3_0)) {
                out.writeString(this.restoreUUID);
            }
            this.snapshot.writeTo(out);
            Version.writeVersion(this.version, out);
            out.writeString(this.index);
        }

        @Override
        public Type getType() {
            return Type.SNAPSHOT;
        }

        @Override
        public void addAdditionalFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("repository", this.snapshot.getRepository()).field("snapshot", this.snapshot.getSnapshotId().getName()).field("version", this.version.toString()).field("index", this.index).field("restoreUUID", this.restoreUUID);
        }

        public String toString() {
            return "snapshot recovery [" + this.restoreUUID + "] from " + this.snapshot;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotRecoverySource that = (SnapshotRecoverySource)o;
            return this.restoreUUID.equals(that.restoreUUID) && this.snapshot.equals(that.snapshot) && this.index.equals(that.index) && this.version.equals(that.version);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.restoreUUID, this.snapshot, this.index, this.version);
        }
    }

    public static class LocalShardsRecoverySource
    extends RecoverySource {
        public static final LocalShardsRecoverySource INSTANCE = new LocalShardsRecoverySource();

        private LocalShardsRecoverySource() {
        }

        @Override
        public Type getType() {
            return Type.LOCAL_SHARDS;
        }

        public String toString() {
            return "local shards recovery";
        }
    }
}

