/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class RepositoryMetadata {
    private final String name;
    private final String type;
    private final Settings settings;

    public RepositoryMetadata(String name, String type, Settings settings) {
        this.name = name;
        this.type = type;
        this.settings = settings;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Settings settings() {
        return this.settings;
    }

    public RepositoryMetadata(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        Settings.writeSettingsToStream(this.settings, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadata that = (RepositoryMetadata)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.settings.hashCode();
        return result;
    }
}

