/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class MetadataIndexUpgradeService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataIndexUpgradeService.class);
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final MapperRegistry mapperRegistry;
    private final IndexScopedSettings indexScopedSettings;
    private final UnaryOperator<IndexMetadata> upgraders;

    public MetadataIndexUpgradeService(Settings settings, NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, IndexScopedSettings indexScopedSettings, Collection<UnaryOperator<IndexMetadata>> indexMetadataUpgraders) {
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.mapperRegistry = mapperRegistry;
        this.indexScopedSettings = indexScopedSettings;
        this.upgraders = indexMetadata -> {
            IndexMetadata newIndexMetadata = indexMetadata;
            for (UnaryOperator upgrader : indexMetadataUpgraders) {
                newIndexMetadata = (IndexMetadata)upgrader.apply(newIndexMetadata);
            }
            return newIndexMetadata;
        };
    }

    public IndexMetadata upgradeIndexMetadata(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (this.isUpgraded(indexMetadata)) {
            return indexMetadata;
        }
        this.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata newMetadata = indexMetadata;
        newMetadata = this.archiveBrokenIndexSettings(newMetadata);
        newMetadata = (IndexMetadata)this.upgraders.apply(newMetadata);
        this.checkMappingsCompatibility(newMetadata);
        return this.markAsUpgraded(newMetadata);
    }

    boolean isUpgraded(IndexMetadata indexMetadata) {
        return indexMetadata.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN && !MetadataIndexUpgradeService.isSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion)) {
            throw new IllegalStateException("The index [" + indexMetadata.getIndex() + "] was created with version [" + indexMetadata.getCreationVersion() + "] but the minimum compatible version is [" + minimumIndexCompatibilityVersion + "].It should be re-indexed in the previous major version of CrateDB before upgrading to " + Version.CURRENT + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        return indexMetadata.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    private void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            IndexSettings indexSettings = new IndexSettings(indexMetadata, this.settings);
            final NamedAnalyzer fakeDefault = new NamedAnalyzer("fake_default", AnalyzerScope.INDEX, new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    throw new UnsupportedOperationException("shouldn't be here");
                }
            });
            AbstractMap<String, NamedAnalyzer> analyzerMap = new AbstractMap<String, NamedAnalyzer>(){

                @Override
                public NamedAnalyzer get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + key.getClass();
                    return new NamedAnalyzer((String)key, AnalyzerScope.INDEX, fakeDefault.analyzer());
                }

                @Override
                public Set<Map.Entry<String, NamedAnalyzer>> entrySet() {
                    return Collections.emptySet();
                }
            };
            try (IndexAnalyzers fakeIndexAnalzyers = new IndexAnalyzers(indexSettings, fakeDefault, fakeDefault, fakeDefault, (Map<String, NamedAnalyzer>)analyzerMap, (Map<String, NamedAnalyzer>)analyzerMap, (Map<String, NamedAnalyzer>)analyzerMap);){
                MapperService mapperService = new MapperService(indexSettings, fakeIndexAnalzyers, this.xContentRegistry, this.mapperRegistry, () -> null);
                mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + indexMetadata.getIndex() + "]", ex);
        }
    }

    private IndexMetadata markAsUpgraded(IndexMetadata indexMetadata) {
        Settings settings = Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetadata.builder(indexMetadata).settings(settings).build();
    }

    IndexMetadata archiveBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> LOGGER.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> LOGGER.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetadata.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetadata.builder(indexMetadata).settings(upgrade).build();
        }
        return indexMetadata;
    }
}

