/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfoBuilder;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataCreateIndexService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataCreateIndexService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(MetadataCreateIndexService.class));
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final boolean forbidPrivateIndexSettings;
    private final Settings settings;
    private final ShardLimitValidator shardLimitValidator;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public MetadataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, ShardLimitValidator shardLimitValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, boolean forbidPrivateIndexSettings) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
        this.shardLimitValidator = shardLimitValidator;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver();
    }

    public static void validateIndexName(String index, ClusterState state) {
        MetadataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            DEPRECATION_LOGGER.deprecated("index or alias name [" + index + "] containing ':' is deprecated. CrateDB 4.x will read, but not allow creation of new indices containing ':'", new Object[0]);
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > 255)");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(NodeContext nodeContext, CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(nodeContext, request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        LOGGER.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(NodeContext nodeContext, CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        request.settings(build);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new IndexCreationTask(LOGGER, this.allocationService, request, listener, this.indicesService, this.aliasValidator, this.xContentRegistry, this.settings, this::validate, this.indexScopedSettings, nodeContext, this.indexNameExpressionResolver));
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        MetadataCreateIndexService.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings(), state, this.forbidPrivateIndexSettings);
        this.shardLimitValidator.validateShardLimit(request.settings(), state);
    }

    public void validateIndexSettings(String indexName, Settings settings, ClusterState clusterState, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    public List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings) {
        Path resolvedPath;
        String customPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + this.env.sharedDataFile() + "]");
        }
        if (forbidPrivateIndexSettings) {
            for (String key : settings.keySet()) {
                Setting<?> setting = this.indexScopedSettings.get(key);
                if (setting == null) {
                    assert (this.indexScopedSettings.isPrivateSetting(key));
                    continue;
                }
                if (!setting.isPrivateIndex()) continue;
                validationErrors.add("private index setting [" + key + "] can not be set explicitly");
            }
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        assert (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetadata.selectShrinkShards(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetadata.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetadata.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexMappingsTypes, targetIndexName, targetIndexSettings);
        IndexMetadata.selectSplitShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetadata validateResize(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metadata().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(targetIndexName).getIndex());
        }
        IndexMetadata sourceMetadata = state.metadata().index(sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to resize index. use \"index.blocks.write=true\"");
        }
        if (targetIndexMappingsTypes.size() > 1) {
            throw new IllegalArgumentException("mappings are not allowed when resizing indices, all mappings are copied from the source index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetadata.getRoutingFactor(sourceMetadata.getNumberOfShards(), IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetadata;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        IndexMetadata sourceMetadata = currentState.metadata().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetadataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id", Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray())).put(IndexMetadata.INDEX_SHRINK_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_SHRINK_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
        } else if (type == ResizeType.SPLIT) {
            MetadataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), mappingKeys, resizeIntoName, indexSettingsBuilder.build());
        } else {
            throw new IllegalStateException("unknown resize type is " + type);
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetadata.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetadata.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.mapping.single_type") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetadata.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetadata.getCreationVersion()).put("index.version.upgraded", sourceMetadata.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetadata.getRoutingPartitionSize()).put(IndexMetadata.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    static class IndexCreationTask
    extends AckedClusterStateUpdateTask<ClusterStateUpdateResponse> {
        private final IndicesService indicesService;
        private final AliasValidator aliasValidator;
        private final NamedXContentRegistry xContentRegistry;
        private final CreateIndexClusterStateUpdateRequest request;
        private final Logger logger;
        private final AllocationService allocationService;
        private final Settings settings;
        private final IndexValidator validator;
        private final IndexScopedSettings indexScopedSettings;
        private final NodeContext nodeContext;
        private final IndexNameExpressionResolver indexNameExpressionResolver;

        IndexCreationTask(Logger logger, AllocationService allocationService, CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener, IndicesService indicesService, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, Settings settings, IndexValidator validator, IndexScopedSettings indexScopedSettings, NodeContext nodeContext, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(Priority.URGENT, request, listener);
            this.request = request;
            this.logger = logger;
            this.allocationService = allocationService;
            this.indicesService = indicesService;
            this.aliasValidator = aliasValidator;
            this.xContentRegistry = xContentRegistry;
            this.settings = settings;
            this.validator = validator;
            this.indexScopedSettings = indexScopedSettings;
            this.nodeContext = nodeContext;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        @Override
        protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
            return new ClusterStateUpdateResponse(acknowledged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            Index createdIndex = null;
            String removalExtraInfo = null;
            IndicesClusterStateService.AllocatedIndices.IndexRemovalReason removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
            try {
                IndexMetadata indexMetadata;
                int routingNumShards;
                this.validator.validate(this.request, currentState);
                for (Alias alias : this.request.aliases()) {
                    this.aliasValidator.validateAlias(alias, this.request.index(), currentState.metadata());
                }
                List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findTemplates(currentState.metadata(), this.request.index());
                HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
                HashMap<String, AliasMetadata> templatesAliases = new HashMap<String, AliasMetadata>();
                ArrayList<String> templateNames = new ArrayList<String>();
                for (Map.Entry<String, String> entry : this.request.mappings().entrySet()) {
                    mappings.put(entry.getKey(), MapperService.parseMapping(this.xContentRegistry, entry.getValue()));
                }
                Index recoverFromIndex = this.request.recoverFrom();
                if (recoverFromIndex == null) {
                    for (IndexTemplateMetadata template : templates) {
                        templateNames.add(template.getName());
                        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : template.mappings()) {
                            String mappingString = ((CompressedXContent)objectObjectCursor.value).string();
                            if (mappings.containsKey(objectObjectCursor.key)) {
                                XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MapperService.parseMapping(this.xContentRegistry, mappingString));
                                continue;
                            }
                            mappings.put((String)objectObjectCursor.key, MapperService.parseMapping(this.xContentRegistry, mappingString));
                        }
                        for (ObjectObjectCursor objectObjectCursor : template.aliases()) {
                            AliasMetadata aliasMetadata = (AliasMetadata)objectObjectCursor.value;
                            if (this.request.aliases().contains(new Alias(aliasMetadata.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                            if (aliasMetadata.alias().contains("{index}")) {
                                String templatedAlias = aliasMetadata.alias().replace("{index}", this.request.index());
                                aliasMetadata = AliasMetadata.newAliasMetadata(aliasMetadata, templatedAlias);
                            }
                            this.aliasValidator.validateAliasMetadata(aliasMetadata, this.request.index(), currentState.metadata());
                            templatesAliases.put(aliasMetadata.alias(), aliasMetadata);
                        }
                    }
                }
                Settings.Builder builder = Settings.builder();
                if (recoverFromIndex == null) {
                    for (int i = templates.size() - 1; i >= 0; --i) {
                        builder.put(templates.get(i).settings());
                    }
                }
                builder.put(this.request.settings());
                if (builder.get("index.number_of_shards") == null) {
                    throw new IllegalArgumentException("Number of shards must be supplied");
                }
                if (builder.get("index.number_of_replicas") == null) {
                    builder.put("index.number_of_replicas", this.settings.getAsInt("index.number_of_replicas", 1));
                }
                if (this.settings.get("index.auto_expand_replicas") != null && builder.get("index.auto_expand_replicas") == null) {
                    builder.put("index.auto_expand_replicas", this.settings.get("index.auto_expand_replicas"));
                }
                if (builder.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey()) == null) {
                    DiscoveryNodes nodes = currentState.nodes();
                    Version createdVersion = Version.min(Version.CURRENT, nodes.getSmallestNonClientNodeVersion());
                    builder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), createdVersion);
                }
                if (builder.get("index.creation_date") == null) {
                    builder.put("index.creation_date", Instant.now().toEpochMilli());
                }
                builder.put("index.provided_name", this.request.getProvidedName());
                builder.put("index.uuid", UUIDs.randomBase64UUID());
                IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(this.request.index());
                if (recoverFromIndex == null) {
                    Settings settings = builder.build();
                    routingNumShards = IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(settings);
                } else {
                    assert (!IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(builder.build())) : "index.number_of_routing_shards should be present on the target index on resize";
                    IndexMetadata indexMetadata2 = currentState.metadata().getIndexSafe(recoverFromIndex);
                    routingNumShards = indexMetadata2.getRoutingNumShards();
                }
                builder.remove(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey());
                tmpImdBuilder.setRoutingNumShards(routingNumShards);
                if (recoverFromIndex != null) {
                    assert (this.request.resizeType() != null);
                    MetadataCreateIndexService.prepareResizeIndexSettings(currentState, mappings.keySet(), builder, recoverFromIndex, this.request.index(), this.request.resizeType(), this.request.copySettings(), this.indexScopedSettings);
                }
                Settings settings = builder.build();
                tmpImdBuilder.settings(settings);
                if (recoverFromIndex != null) {
                    IndexMetadata sourceMetadata = currentState.metadata().getIndexSafe(recoverFromIndex);
                    long primaryTerm = IntStream.range(0, sourceMetadata.getNumberOfShards()).mapToLong(sourceMetadata::primaryTerm).max().getAsLong();
                    for (int shardId = 0; shardId < tmpImdBuilder.numberOfShards(); ++shardId) {
                        tmpImdBuilder.primaryTerm(shardId, primaryTerm);
                    }
                }
                IndexMetadata tmpImd = tmpImdBuilder.build();
                ActiveShardCount waitForActiveShards = this.request.waitForActiveShards();
                if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                    waitForActiveShards = tmpImd.getWaitForActiveShards();
                }
                if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                    throw new IllegalArgumentException("invalid wait_for_active_shards[" + this.request.waitForActiveShards() + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
                }
                IndicesClusterStateService.AllocatedIndex indexService = this.indicesService.createIndex(tmpImd, Collections.emptyList());
                createdIndex = ((AbstractIndexComponent)((Object)indexService)).index();
                MapperService mapperService = ((IndexService)indexService).mapperService();
                if (!mappings.isEmpty()) {
                    assert (mappings.size() == 1);
                    Map.Entry entry = mappings.entrySet().iterator().next();
                    try {
                        mapperService.merge((String)entry.getKey(), (Map)entry.getValue(), MapperService.MergeReason.MAPPING_UPDATE);
                    }
                    catch (Exception e) {
                        removalExtraInfo = "failed on parsing default mapping/mappings on index creation";
                        throw e;
                    }
                }
                HashMap<String, MappingMetadata> mappingsMetadata = new HashMap<String, MappingMetadata>();
                DocumentMapper mapper = mapperService.documentMapper();
                if (mapper != null) {
                    MappingMetadata mappingMd = new MappingMetadata(mapper);
                    mappingsMetadata.put(mapper.type(), mappingMd);
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(this.request.index()).settings(settings).setRoutingNumShards(routingNumShards);
                for (int shardId = 0; shardId < tmpImd.getNumberOfShards(); ++shardId) {
                    indexMetadataBuilder.primaryTerm(shardId, tmpImd.primaryTerm(shardId));
                }
                for (MappingMetadata mappingMd : mappingsMetadata.values()) {
                    indexMetadataBuilder.putMapping(mappingMd);
                }
                for (AliasMetadata aliasMetadata : templatesAliases.values()) {
                    indexMetadataBuilder.putAlias(aliasMetadata);
                }
                for (Alias alias : this.request.aliases()) {
                    AliasMetadata aliasMetadata = AliasMetadata.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).build();
                    indexMetadataBuilder.putAlias(aliasMetadata);
                }
                indexMetadataBuilder.state(this.request.state());
                try {
                    indexMetadata = indexMetadataBuilder.build();
                }
                catch (Exception e) {
                    removalExtraInfo = "failed to build index metadata";
                    throw e;
                }
                ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
                Metadata newMetadata = Metadata.builder(currentState.metadata()).put(indexMetadata, false).build();
                this.logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}], mappings {}", (Object)this.request.index(), (Object)this.request.cause(), templateNames, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas(), mappings.keySet());
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                if (!this.request.blocks().isEmpty()) {
                    for (ClusterBlock block : this.request.blocks()) {
                        blocks.addIndexBlock(this.request.index(), block);
                    }
                }
                blocks.updateBlocks(indexMetadata);
                ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metadata(newMetadata).build();
                if (this.request.state() == IndexMetadata.State.OPEN) {
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metadata().index(this.request.index()));
                    updatedState = this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "index [" + this.request.index() + "] created");
                }
                removalExtraInfo = "cleaning up after validating index on master";
                removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
                this.ensureTableInfoCanBeCreated(this.request.index(), updatedState);
                ClusterState clusterState = updatedState;
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                return clusterState;
            }
            catch (Throwable throwable) {
                if (createdIndex != null) {
                    this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                }
                throw throwable;
            }
        }

        private void ensureTableInfoCanBeCreated(String index, ClusterState updatedState) {
            if (IndexParts.isDangling(index)) {
                return;
            }
            RelationName relationName = RelationName.fromIndexName(this.request.index());
            DocTableInfoBuilder builder = new DocTableInfoBuilder(this.nodeContext, relationName, updatedState, this.indexNameExpressionResolver);
            builder.build();
        }

        @Override
        public void onFailure(String source, Exception e) {
            if (e instanceof ResourceAlreadyExistsException) {
                this.logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            } else {
                this.logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)this.request.index()), (Throwable)e);
            }
            super.onFailure(source, e);
        }
    }

    static interface IndexValidator {
        public void validate(CreateIndexClusterStateUpdateRequest var1, ClusterState var2);
    }
}

