/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.MapBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.elasticsearch.Assertions;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AutoExpandReplicas;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;

public class IndexMetadata
implements Diffable<IndexMetadata>,
ToXContentFragment {
    public static final ClusterBlock INDEX_CLOSED_BLOCK = new ClusterBlock(4, "index closed", false, false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.READ_WRITE);
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
    public static final ClusterBlock INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final ClusterBlock INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
    public static final ClusterBlock INDEX_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(12, "index read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.WRITE));
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final Setting<Integer> INDEX_NUMBER_OF_SHARDS_SETTING = IndexMetadata.buildNumberOfShardsSetting();
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final Setting<Integer> INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting("index.number_of_replicas", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_ROUTING_PARTITION_SIZE = "index.routing_partition_size";
    public static final Setting<Integer> INDEX_ROUTING_PARTITION_SIZE_SETTING = Setting.intSetting("index.routing_partition_size", 1, 1, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING = Setting.intSetting("index.number_of_routing_shards", INDEX_NUMBER_OF_SHARDS_SETTING, 1, new Setting.Validator<Integer>(){

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer numRoutingShards, Map<Setting<Integer>, Integer> settings) {
            Integer numShards = settings.get(INDEX_NUMBER_OF_SHARDS_SETTING);
            if (numRoutingShards < numShards) {
                throw new IllegalArgumentException("index.number_of_routing_shards [" + numRoutingShards + "] must be >= index.number_of_shards [" + numShards + "]");
            }
            IndexMetadata.getRoutingFactor(numShards, numRoutingShards);
        }

        @Override
        public Iterator<Setting<Integer>> settings() {
            return Collections.singleton(INDEX_NUMBER_OF_SHARDS_SETTING).iterator();
        }
    }, Setting.Property.IndexScope);
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final Setting<AutoExpandReplicas> INDEX_AUTO_EXPAND_REPLICAS_SETTING = AutoExpandReplicas.SETTING;
    public static final String SETTING_READ_ONLY = "index.blocks.read_only";
    public static final Setting<Boolean> INDEX_READ_ONLY_SETTING = Setting.boolSetting("index.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_READ = "index.blocks.read";
    public static final Setting<Boolean> INDEX_BLOCKS_READ_SETTING = Setting.boolSetting("index.blocks.read", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_WRITE = "index.blocks.write";
    public static final Setting<Boolean> INDEX_BLOCKS_WRITE_SETTING = Setting.boolSetting("index.blocks.write", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_BLOCKS_METADATA = "index.blocks.metadata";
    public static final Setting<Boolean> INDEX_BLOCKS_METADATA_SETTING = Setting.boolSetting("index.blocks.metadata", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_READ_ONLY_ALLOW_DELETE = "index.blocks.read_only_allow_delete";
    public static final Setting<Boolean> INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("index.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final Setting<Version> SETTING_INDEX_VERSION_CREATED = Setting.versionSetting("index.version.created", Version.V_EMPTY, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    public static final String SETTING_INDEX_PROVIDED_NAME = "index.provided_name";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final Setting<Integer> INDEX_PRIORITY_SETTING = Setting.intSetting("index.priority", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final Setting<String> INDEX_DATA_PATH_SETTING = new Setting("index.data_path", "", Function.identity(), Setting.Property.IndexScope);
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    public static final String INDEX_ROUTING_REQUIRE_GROUP_PREFIX = "index.routing.allocation.require";
    public static final String INDEX_ROUTING_INCLUDE_GROUP_PREFIX = "index.routing.allocation.include";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP_PREFIX = "index.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> INDEX_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.initial_recovery.", key -> Setting.simpleString(key, new Setting.Property[0]));
    public static final Setting<ActiveShardCount> SETTING_WAIT_FOR_ACTIVE_SHARDS = new Setting<ActiveShardCount>("index.write.wait_for_active_shards", "1", ActiveShardCount::parseString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final String INDEX_FORMAT = "index.format";
    public static final Setting<Integer> INDEX_FORMAT_SETTING = Setting.intSetting("index.format", 0, Setting.Property.IndexScope, Setting.Property.Final);
    public static final Setting<Boolean> VERIFIED_BEFORE_CLOSE_SETTING = Setting.boolSetting("index.verified_before_close", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final String KEY_IN_SYNC_ALLOCATIONS = "in_sync_allocations";
    static final String KEY_VERSION = "version";
    static final String KEY_MAPPING_VERSION = "mapping_version";
    static final String KEY_SETTINGS_VERSION = "settings_version";
    static final String KEY_ROUTING_NUM_SHARDS = "routing_num_shards";
    static final String KEY_SETTINGS = "settings";
    static final String KEY_STATE = "state";
    static final String KEY_MAPPINGS = "mappings";
    static final String KEY_ALIASES = "aliases";
    public static final String KEY_PRIMARY_TERMS = "primary_terms";
    public static final String INDEX_STATE_FILE_PREFIX = "state-";
    private final int routingNumShards;
    private final int routingFactor;
    private final int routingPartitionSize;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final Index index;
    private final long version;
    private final long mappingVersion;
    private final long settingsVersion;
    private final long[] primaryTerms;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetadata> aliases;
    private final Settings settings;
    private final ImmutableOpenMap<String, MappingMetadata> mappings;
    private final ImmutableOpenMap<String, DiffableStringMap> customData;
    private final ImmutableOpenIntMap<Set<String>> inSyncAllocationIds;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final DiscoveryNodeFilters initialRecoveryFilters;
    private final Version indexCreatedVersion;
    private final Version indexUpgradedVersion;
    private final ActiveShardCount waitForActiveShards;
    public static final String INDEX_SHRINK_SOURCE_UUID_KEY = "index.shrink.source.uuid";
    public static final String INDEX_SHRINK_SOURCE_NAME_KEY = "index.shrink.source.name";
    public static final String INDEX_RESIZE_SOURCE_UUID_KEY = "index.resize.source.uuid";
    public static final String INDEX_RESIZE_SOURCE_NAME_KEY = "index.resize.source.name";
    public static final Setting<String> INDEX_SHRINK_SOURCE_UUID = Setting.simpleString("index.shrink.source.uuid", new Setting.Property[0]);
    public static final Setting<String> INDEX_SHRINK_SOURCE_NAME = Setting.simpleString("index.shrink.source.name", new Setting.Property[0]);
    public static final Setting<String> INDEX_RESIZE_SOURCE_UUID = Setting.simpleString("index.resize.source.uuid", INDEX_SHRINK_SOURCE_UUID, new Setting.Property[0]);
    public static final Setting<String> INDEX_RESIZE_SOURCE_NAME = Setting.simpleString("index.resize.source.name", INDEX_SHRINK_SOURCE_NAME, new Setting.Property[0]);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("binary", "true"));
    public static final MetadataStateFormat<IndexMetadata> FORMAT = new MetadataStateFormat<IndexMetadata>("state-"){

        @Override
        public void toXContent(XContentBuilder builder, IndexMetadata state) throws IOException {
            Builder.toXContent(state, builder, FORMAT_PARAMS);
        }

        @Override
        public IndexMetadata fromXContent(XContentParser parser) throws IOException {
            assert (parser.getXContentRegistry() != NamedXContentRegistry.EMPTY) : "loading index metadata requires a working named xcontent registry";
            return Builder.fromXContent(parser);
        }
    };

    static Setting<Integer> buildNumberOfShardsSetting() {
        int maxNumShards = Integer.parseInt(System.getProperty("es.index.max_number_of_shards", "1024"));
        if (maxNumShards < 1) {
            throw new IllegalArgumentException("es.index.max_number_of_shards must be > 0");
        }
        return Setting.intSetting(SETTING_NUMBER_OF_SHARDS, Math.min(5, maxNumShards), 1, maxNumShards, Setting.Property.IndexScope, Setting.Property.Final);
    }

    private IndexMetadata(Index index, long version, long mappingVersion, long settingsVersion, long[] primaryTerms, State state, int numberOfShards, int numberOfReplicas, Settings settings, ImmutableOpenMap<String, MappingMetadata> mappings, ImmutableOpenMap<String, AliasMetadata> aliases, ImmutableOpenMap<String, DiffableStringMap> customData, ImmutableOpenIntMap<Set<String>> inSyncAllocationIds, DiscoveryNodeFilters requireFilters, DiscoveryNodeFilters initialRecoveryFilters, DiscoveryNodeFilters includeFilters, DiscoveryNodeFilters excludeFilters, Version indexCreatedVersion, Version indexUpgradedVersion, int routingNumShards, int routingPartitionSize, ActiveShardCount waitForActiveShards) {
        this.index = index;
        this.version = version;
        assert (mappingVersion >= 0L) : mappingVersion;
        this.mappingVersion = mappingVersion;
        assert (settingsVersion >= 0L) : settingsVersion;
        this.settingsVersion = settingsVersion;
        this.primaryTerms = primaryTerms;
        assert (primaryTerms.length == numberOfShards);
        this.state = state;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.settings = settings;
        this.mappings = mappings;
        this.customData = customData;
        this.aliases = aliases;
        this.inSyncAllocationIds = inSyncAllocationIds;
        this.requireFilters = requireFilters;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.initialRecoveryFilters = initialRecoveryFilters;
        this.indexCreatedVersion = indexCreatedVersion;
        this.indexUpgradedVersion = indexUpgradedVersion;
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingNumShards / numberOfShards;
        this.routingPartitionSize = routingPartitionSize;
        this.waitForActiveShards = waitForActiveShards;
        assert (numberOfShards * this.routingFactor == routingNumShards) : routingNumShards + " must be a multiple of " + numberOfShards;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public long getMappingVersion() {
        return this.mappingVersion;
    }

    public long getSettingsVersion() {
        return this.settingsVersion;
    }

    public long primaryTerm(int shardId) {
        return this.primaryTerms[shardId];
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public Version getUpgradedVersion() {
        return this.indexUpgradedVersion;
    }

    public long getCreationDate() {
        return this.settings.getAsLong(SETTING_CREATION_DATE, -1L);
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getRoutingPartitionSize() {
        return this.routingPartitionSize;
    }

    public boolean isRoutingPartitionedIndex() {
        return this.routingPartitionSize != 1;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    @Nullable
    public MappingMetadata mapping() {
        Iterator<ObjectObjectCursor<String, MappingMetadata>> iterator = this.mappings.iterator();
        if (iterator.hasNext()) {
            ObjectObjectCursor<String, MappingMetadata> cursor = iterator.next();
            return (MappingMetadata)cursor.value;
        }
        return null;
    }

    public Index getResizeSourceIndex() {
        return INDEX_RESIZE_SOURCE_UUID.exists(this.settings) || INDEX_SHRINK_SOURCE_UUID.exists(this.settings) ? new Index(INDEX_RESIZE_SOURCE_NAME.get(this.settings), INDEX_RESIZE_SOURCE_UUID.get(this.settings)) : null;
    }

    ImmutableOpenMap<String, DiffableStringMap> getCustomData() {
        return this.customData;
    }

    public Map<String, String> getCustomData(String key) {
        return this.customData.get(key);
    }

    public ImmutableOpenIntMap<Set<String>> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public Set<String> inSyncAllocationIds(int shardId) {
        assert (shardId >= 0 && shardId < this.numberOfShards);
        return this.inSyncAllocationIds.get(shardId);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters getInitialRecoveryFilters() {
        return this.initialRecoveryFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetadata that = (IndexMetadata)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.customData.equals(that.customData)) {
            return false;
        }
        if (this.routingNumShards != that.routingNumShards) {
            return false;
        }
        if (this.routingFactor != that.routingFactor) {
            return false;
        }
        if (!Arrays.equals(this.primaryTerms, that.primaryTerms)) {
            return false;
        }
        return this.inSyncAllocationIds.equals(that.inSyncAllocationIds);
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.customData.hashCode();
        result = 31 * result + Long.hashCode(this.routingFactor);
        result = 31 * result + Long.hashCode(this.routingNumShards);
        result = 31 * result + Arrays.hashCode(this.primaryTerms);
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        return result;
    }

    @Override
    public Diff<IndexMetadata> diff(IndexMetadata previousState) {
        return new IndexMetadataDiff(previousState, this);
    }

    public static Diff<IndexMetadata> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetadataDiff(in);
    }

    public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static IndexMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        builder.mappingVersion(in.readVLong());
        builder.settingsVersion(in.readVLong());
        builder.setRoutingNumShards(in.readInt());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        builder.primaryTerms(in.readVLongArray());
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetadata mappingMd = new MappingMetadata(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String key = in.readString();
            DiffableStringMap custom = new DiffableStringMap(in);
            builder.putCustom(key, custom);
        }
        int inSyncAllocationIdsSize = in.readVInt();
        for (int i = 0; i < inSyncAllocationIdsSize; ++i) {
            int key = in.readVInt();
            Object allocationIds = DiffableUtils.StringSetValueSerializer.getInstance().read(in, (Object)key);
            builder.putInSyncAllocationIds(key, (Set<String>)allocationIds);
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index.getName());
        out.writeLong(this.version);
        out.writeVLong(this.mappingVersion);
        out.writeVLong(this.settingsVersion);
        out.writeInt(this.routingNumShards);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVLongArray(this.primaryTerms);
        out.writeVInt(this.mappings.size());
        for (IntObjectCursor cursor : this.mappings.values()) {
            ((MappingMetadata)cursor.value).writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (IntObjectCursor cursor : this.aliases.values()) {
            ((AliasMetadata)cursor.value).writeTo(out);
        }
        out.writeVInt(this.customData.size());
        for (IntObjectCursor cursor : this.customData) {
            out.writeString((String)cursor.key);
            ((DiffableStringMap)cursor.value).writeTo(out);
        }
        out.writeVInt(this.inSyncAllocationIds.size());
        for (IntObjectCursor cursor : this.inSyncAllocationIds) {
            out.writeVInt(cursor.key);
            DiffableUtils.StringSetValueSerializer.getInstance().write((Set)cursor.value, out);
        }
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetadata indexMetadata) {
        return new Builder(indexMetadata);
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Version versionUpgraded;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = SETTING_INDEX_VERSION_CREATED.get(settings);
        if (version != Version.V_EMPTY) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((versionUpgraded = settings.getAsVersion(SETTING_VERSION_UPGRADED, null)) != null) {
            builder.put(SETTING_VERSION_UPGRADED_STRING, versionUpgraded.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            ZonedDateTime creationDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationDate), ZoneOffset.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    public int getRoutingNumShards() {
        return this.routingNumShards;
    }

    public int getRoutingFactor() {
        return this.routingFactor;
    }

    public static ShardId selectSplitShard(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (numSourceShards > numTargetShards) {
            throw new IllegalArgumentException("the number of source shards [" + numSourceShards + "] must be less that the number of target shards [" + numTargetShards + "]");
        }
        int routingFactor = IndexMetadata.getRoutingFactor(numSourceShards, numTargetShards);
        int routingNumShards = sourceIndexMetadata.getRoutingNumShards();
        if (routingNumShards % numTargetShards != 0) {
            throw new IllegalStateException("the number of routing shards [" + routingNumShards + "] must be a multiple of the target shards [" + numTargetShards + "]");
        }
        assert (IndexMetadata.getRoutingFactor(numTargetShards, sourceIndexMetadata.getRoutingNumShards()) >= 0);
        return new ShardId(sourceIndexMetadata.getIndex(), shardId / routingFactor);
    }

    public static Set<ShardId> selectRecoverFromShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (sourceIndexMetadata.getNumberOfShards() > numTargetShards) {
            return IndexMetadata.selectShrinkShards(shardId, sourceIndexMetadata, numTargetShards);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            return Collections.singleton(IndexMetadata.selectSplitShard(shardId, sourceIndexMetadata, numTargetShards));
        }
        throw new IllegalArgumentException("can't select recover from shards if both indices have the same number of shards");
    }

    public static Set<ShardId> selectShrinkShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            throw new IllegalArgumentException("the number of target shards [" + numTargetShards + "] must be less that the number of source shards [" + sourceIndexMetadata.getNumberOfShards() + "]");
        }
        int routingFactor = IndexMetadata.getRoutingFactor(sourceIndexMetadata.getNumberOfShards(), numTargetShards);
        HashSet<ShardId> shards = new HashSet<ShardId>(routingFactor);
        for (int i = shardId * routingFactor; i < routingFactor * shardId + routingFactor; ++i) {
            shards.add(new ShardId(sourceIndexMetadata.getIndex(), i));
        }
        return shards;
    }

    public static int getRoutingFactor(int sourceNumberOfShards, int targetNumberOfShards) {
        int factor;
        if (sourceNumberOfShards < targetNumberOfShards) {
            factor = targetNumberOfShards / sourceNumberOfShards;
            if (factor * sourceNumberOfShards != targetNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a must be a factor of [" + targetNumberOfShards + "]");
            }
        } else if (sourceNumberOfShards > targetNumberOfShards) {
            factor = sourceNumberOfShards / targetNumberOfShards;
            if (factor * targetNumberOfShards != sourceNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a must be a multiple of [" + targetNumberOfShards + "]");
            }
        } else {
            factor = 1;
        }
        return factor;
    }

    public static boolean isIndexVerifiedBeforeClosed(IndexMetadata indexMetadata) {
        return indexMetadata.getState() == State.CLOSE && VERIFIED_BEFORE_CLOSE_SETTING.exists(indexMetadata.getSettings()) && VERIFIED_BEFORE_CLOSE_SETTING.get(indexMetadata.getSettings()) != false;
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }

    private static class IndexMetadataDiff
    implements Diff<IndexMetadata> {
        private final String index;
        private final int routingNumShards;
        private final long version;
        private final long mappingVersion;
        private final long settingsVersion;
        private final long[] primaryTerms;
        private final State state;
        private final Settings settings;
        private final Diff<ImmutableOpenMap<String, MappingMetadata>> mappings;
        private final Diff<ImmutableOpenMap<String, AliasMetadata>> aliases;
        private final Diff<ImmutableOpenMap<String, DiffableStringMap>> customData;
        private final Diff<ImmutableOpenIntMap<Set<String>>> inSyncAllocationIds;

        IndexMetadataDiff(IndexMetadata before, IndexMetadata after) {
            this.index = after.index.getName();
            this.version = after.version;
            this.mappingVersion = after.mappingVersion;
            this.settingsVersion = after.settingsVersion;
            this.routingNumShards = after.routingNumShards;
            this.state = after.state;
            this.settings = after.settings;
            this.primaryTerms = after.primaryTerms;
            this.mappings = DiffableUtils.diff(before.mappings, after.mappings, DiffableUtils.getStringKeySerializer());
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases, DiffableUtils.getStringKeySerializer());
            this.customData = DiffableUtils.diff(before.customData, after.customData, DiffableUtils.getStringKeySerializer());
            this.inSyncAllocationIds = DiffableUtils.diff(before.inSyncAllocationIds, after.inSyncAllocationIds, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
        }

        IndexMetadataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.routingNumShards = in.readInt();
            this.version = in.readLong();
            this.mappingVersion = in.readVLong();
            this.settingsVersion = in.readVLong();
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.primaryTerms = in.readVLongArray();
            this.mappings = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), MappingMetadata::new, MappingMetadata::readDiffFrom);
            this.aliases = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), AliasMetadata::new, AliasMetadata::readDiffFrom);
            this.customData = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), DiffableStringMap::new, DiffableStringMap::readDiffFrom);
            this.inSyncAllocationIds = DiffableUtils.readImmutableOpenIntMapDiff(in, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeInt(this.routingNumShards);
            out.writeLong(this.version);
            out.writeVLong(this.mappingVersion);
            out.writeVLong(this.settingsVersion);
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            out.writeVLongArray(this.primaryTerms);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customData.writeTo(out);
            this.inSyncAllocationIds.writeTo(out);
        }

        @Override
        public IndexMetadata apply(IndexMetadata part) {
            Builder builder = IndexMetadata.builder(this.index);
            builder.version(this.version);
            builder.mappingVersion(this.mappingVersion);
            builder.settingsVersion(this.settingsVersion);
            builder.setRoutingNumShards(this.routingNumShards);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.primaryTerms(this.primaryTerms);
            builder.mappings.putAll((Iterable<ObjectObjectCursor<String, MappingMetadata>>)this.mappings.apply(part.mappings));
            builder.aliases.putAll((Iterable<ObjectObjectCursor<String, AliasMetadata>>)this.aliases.apply(part.aliases));
            builder.customMetadata.putAll((Iterable<ObjectObjectCursor<String, DiffableStringMap>>)this.customData.apply(part.customData));
            builder.inSyncAllocationIds.putAll((Iterable<IntObjectCursor<Set<String>>>)this.inSyncAllocationIds.apply(part.inSyncAllocationIds));
            return builder.build();
        }
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private long mappingVersion = 1L;
        private long settingsVersion = 1L;
        private long[] primaryTerms = null;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, MappingMetadata> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetadata> aliases;
        private final ImmutableOpenMap.Builder<String, DiffableStringMap> customMetadata;
        private final ImmutableOpenIntMap.Builder<Set<String>> inSyncAllocationIds;
        private Integer routingNumShards;

        public Builder(String index) {
            this.index = index;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customMetadata = ImmutableOpenMap.builder();
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder();
        }

        public Builder(IndexMetadata indexMetadata) {
            this.index = indexMetadata.getIndex().getName();
            this.state = indexMetadata.state;
            this.version = indexMetadata.version;
            this.mappingVersion = indexMetadata.mappingVersion;
            this.settingsVersion = indexMetadata.settingsVersion;
            this.settings = indexMetadata.getSettings();
            this.primaryTerms = (long[])indexMetadata.primaryTerms.clone();
            this.mappings = ImmutableOpenMap.builder(indexMetadata.mappings);
            this.aliases = ImmutableOpenMap.builder(indexMetadata.aliases);
            this.customMetadata = ImmutableOpenMap.builder(indexMetadata.customData);
            this.routingNumShards = indexMetadata.routingNumShards;
            this.inSyncAllocationIds = ImmutableOpenIntMap.builder(indexMetadata.inSyncAllocationIds);
        }

        public String index() {
            return this.index;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public Builder setRoutingNumShards(int routingNumShards) {
            this.routingNumShards = routingNumShards;
            return this;
        }

        public int getRoutingNumShards() {
            return this.routingNumShards == null ? this.numberOfShards() : this.routingNumShards.intValue();
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public int numberOfReplicas() {
            return this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_REPLICAS, -1);
        }

        public Builder routingPartitionSize(int routingPartitionSize) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_ROUTING_PARTITION_SIZE, routingPartitionSize).build();
            return this;
        }

        public int routingPartitionSize() {
            return this.settings.getAsInt(IndexMetadata.SETTING_ROUTING_PARTITION_SIZE, -1);
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetadata mapping(String type) {
            return this.mappings.get(type);
        }

        public Builder putMapping(String type, String source) throws IOException {
            this.putMapping(new MappingMetadata(type, XContentHelper.convertToMap(XContentFactory.xContent(source), source, true)));
            return this;
        }

        public Builder putMapping(MappingMetadata mappingMd) {
            this.mappings.clear();
            if (mappingMd != null) {
                this.mappings.put(mappingMd.type(), mappingMd);
            }
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Map<String, String> customIndexMetadata) {
            this.customMetadata.put(type, new DiffableStringMap(customIndexMetadata));
            return this;
        }

        public Map<String, String> removeCustom(String type) {
            return this.customMetadata.remove(type);
        }

        public Set<String> getInSyncAllocationIds(int shardId) {
            return this.inSyncAllocationIds.get(shardId);
        }

        public Builder putInSyncAllocationIds(int shardId, Set<String> allocationIds) {
            this.inSyncAllocationIds.put(shardId, new HashSet<String>(allocationIds));
            return this;
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public long mappingVersion() {
            return this.mappingVersion;
        }

        public long settingsVersion() {
            return this.settingsVersion;
        }

        public Builder mappingVersion(long mappingVersion) {
            this.mappingVersion = mappingVersion;
            return this;
        }

        public Builder settingsVersion(long settingsVersion) {
            this.settingsVersion = settingsVersion;
            return this;
        }

        public long primaryTerm(int shardId) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            return this.primaryTerms[shardId];
        }

        public Builder primaryTerm(int shardId, long primaryTerm) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            this.primaryTerms[shardId] = primaryTerm;
            return this;
        }

        private void primaryTerms(long[] primaryTerms) {
            this.primaryTerms = (long[])primaryTerms.clone();
        }

        private void initializePrimaryTerms() {
            assert (this.primaryTerms == null);
            if (this.numberOfShards() < 0) {
                throw new IllegalStateException("you must set the number of shards before setting/reading primary terms");
            }
            this.primaryTerms = new long[this.numberOfShards()];
        }

        public IndexMetadata build() {
            ImmutableOpenMap.Builder<String, AliasMetadata> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            Integer maybeNumberOfShards = this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_SHARDS, null);
            if (maybeNumberOfShards == null) {
                throw new IllegalArgumentException("must specify numberOfShards for index [" + this.index + "]");
            }
            int numberOfShards = maybeNumberOfShards;
            if (numberOfShards <= 0) {
                throw new IllegalArgumentException("must specify positive number of shards for index [" + this.index + "]");
            }
            Integer maybeNumberOfReplicas = this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_REPLICAS, null);
            if (maybeNumberOfReplicas == null) {
                throw new IllegalArgumentException("must specify numberOfReplicas for index [" + this.index + "]");
            }
            int numberOfReplicas = maybeNumberOfReplicas;
            if (numberOfReplicas < 0) {
                throw new IllegalArgumentException("must specify non-negative number of shards for index [" + this.index + "]");
            }
            int routingPartitionSize = INDEX_ROUTING_PARTITION_SIZE_SETTING.get(this.settings);
            if (routingPartitionSize != 1 && routingPartitionSize >= this.getRoutingNumShards()) {
                throw new IllegalArgumentException("routing partition size [" + routingPartitionSize + "] should be a positive number less than the number of shards [" + this.getRoutingNumShards() + "] for [" + this.index + "]");
            }
            ImmutableOpenIntMap.Builder filledInSyncAllocationIds = ImmutableOpenIntMap.builder();
            for (int i = 0; i < numberOfShards; ++i) {
                if (this.inSyncAllocationIds.containsKey(i)) {
                    filledInSyncAllocationIds.put(i, Collections.unmodifiableSet(new HashSet(this.inSyncAllocationIds.get(i))));
                    continue;
                }
                filledInSyncAllocationIds.put(i, Collections.emptySet());
            }
            Map<String, String> requireMap = INDEX_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            Map<String, String> includeMap = INDEX_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            Map<String, String> excludeMap = INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            Map<String, String> initialRecoveryMap = INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters initialRecoveryFilters = initialRecoveryMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, initialRecoveryMap);
            Version indexCreatedVersion = Version.indexCreated(this.settings);
            Version indexUpgradedVersion = this.settings.getAsVersion(IndexMetadata.SETTING_VERSION_UPGRADED, indexCreatedVersion);
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            } else if (this.primaryTerms.length != numberOfShards) {
                throw new IllegalStateException("primaryTerms length is [" + this.primaryTerms.length + "] but should be equal to number of shards [" + this.numberOfShards() + "]");
            }
            ActiveShardCount waitForActiveShards = SETTING_WAIT_FOR_ACTIVE_SHARDS.get(this.settings);
            if (!waitForActiveShards.validate(numberOfReplicas)) {
                throw new IllegalArgumentException("invalid " + SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey() + "[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (numberOfReplicas + 1) + "]");
            }
            String uuid = this.settings.get(IndexMetadata.SETTING_INDEX_UUID, IndexMetadata.INDEX_UUID_NA_VALUE);
            return new IndexMetadata(new Index(this.index, uuid), this.version, this.mappingVersion, this.settingsVersion, this.primaryTerms, this.state, numberOfShards, numberOfReplicas, tmpSettings, this.mappings.build(), tmpAliases.build(), this.customMetadata.build(), filledInSyncAllocationIds.build(), requireFilters, initialRecoveryFilters, includeFilters, excludeFilters, indexCreatedVersion, indexUpgradedVersion, this.getRoutingNumShards(), routingPartitionSize, waitForActiveShards);
        }

        public static void toXContent(IndexMetadata indexMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetadata.getIndex().getName());
            builder.field(IndexMetadata.KEY_VERSION, indexMetadata.getVersion());
            builder.field(IndexMetadata.KEY_MAPPING_VERSION, indexMetadata.getMappingVersion());
            builder.field(IndexMetadata.KEY_SETTINGS_VERSION, indexMetadata.getSettingsVersion());
            builder.field(IndexMetadata.KEY_ROUTING_NUM_SHARDS, indexMetadata.getRoutingNumShards());
            builder.field(IndexMetadata.KEY_STATE, indexMetadata.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(IndexMetadata.KEY_SETTINGS);
            indexMetadata.getSettings().toXContent(builder, new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            builder.endObject();
            builder.startArray(IndexMetadata.KEY_MAPPINGS);
            MappingMetadata mmd = indexMetadata.mapping();
            if (mmd != null) {
                if (binary) {
                    builder.value(mmd.source().compressed());
                } else {
                    builder.map(XContentHelper.convertToMap(new BytesArray(mmd.source().uncompressed()), true).v2());
                }
            }
            builder.endArray();
            for (ObjectObjectCursor<String, DiffableStringMap> objectObjectCursor : indexMetadata.customData) {
                builder.field((String)objectObjectCursor.key);
                builder.map((Map)objectObjectCursor.value);
            }
            builder.startObject(IndexMetadata.KEY_ALIASES);
            for (ObjectCursor objectCursor : indexMetadata.getAliases().values()) {
                AliasMetadata.Builder.toXContent((AliasMetadata)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.startArray(IndexMetadata.KEY_PRIMARY_TERMS);
            for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                builder.value(indexMetadata.primaryTerm(i));
            }
            builder.endArray();
            builder.startObject(IndexMetadata.KEY_IN_SYNC_ALLOCATIONS);
            for (IntObjectCursor<Set<String>> intObjectCursor : indexMetadata.inSyncAllocationIds) {
                builder.startArray(String.valueOf(intObjectCursor.key));
                for (String allocationId : (Set)intObjectCursor.value) {
                    builder.value(allocationId);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new IllegalArgumentException("expected field name but got a " + parser.currentToken());
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("expected object but got a " + token);
            }
            boolean mappingVersion = false;
            boolean settingsVersion = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetadata.KEY_SETTINGS.equals(currentFieldName)) {
                        builder.settings(Settings.fromXContent(parser));
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                String mappingType = currentFieldName;
                                Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                                builder.putMapping(new MappingMetadata(mappingType, mappingSource));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_ALIASES.equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_IN_SYNC_ALLOCATIONS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                String shardId = currentFieldName;
                                HashSet<String> allocationIds = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    allocationIds.add(parser.text());
                                }
                                builder.putInSyncAllocationIds(Integer.valueOf(shardId), allocationIds);
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if ("warmers".equals(currentFieldName)) {
                        assert (Version.CURRENT.major <= 5);
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(currentFieldName, parser.mapStrings());
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                                builder.putMapping(new MappingMetadata(new CompressedXContent(parser.binaryValue())));
                                continue;
                            }
                            Map<String, Object> mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = mapping.keySet().iterator().next();
                            builder.putMapping(new MappingMetadata(mappingType, mapping));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_PRIMARY_TERMS.equals(currentFieldName)) {
                        LongArrayList list = new LongArrayList();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                list.add(parser.longValue());
                                continue;
                            }
                            throw new IllegalStateException("found a non-numeric value under [primary_terms]");
                        }
                        builder.primaryTerms(list.toArray());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field for an array " + currentFieldName);
                }
                if (token.isValue()) {
                    if (IndexMetadata.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetadata.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPING_VERSION.equals(currentFieldName)) {
                        mappingVersion = true;
                        builder.mappingVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SETTINGS_VERSION.equals(currentFieldName)) {
                        settingsVersion = true;
                        builder.settingsVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) {
                        builder.setRoutingNumShards(parser.intValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            if (Assertions.ENABLED && Version.indexCreated(builder.settings).onOrAfter(Version.V_3_2_0)) assert (mappingVersion) : "mapping version should be present for indices created on or after 6.5.0";
            if (Assertions.ENABLED && Version.indexCreated(builder.settings).onOrAfter(Version.V_3_2_0)) assert (settingsVersion) : "settings version should be present for indices created on or after 6.5.0";
            return builder.build();
        }
    }
}

