/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.common.Booleans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Setting;

public final class AutoExpandReplicas {
    private static final String ALL_NODES_VALUE = "all";
    private static final AutoExpandReplicas FALSE_INSTANCE = new AutoExpandReplicas(0, 0, false);
    public static final Setting<AutoExpandReplicas> SETTING = new Setting<AutoExpandReplicas>("index.auto_expand_replicas", "0-1", AutoExpandReplicas::parse, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private final int minReplicas;
    private final int maxReplicas;
    private final boolean enabled;

    private static AutoExpandReplicas parse(String value) {
        int max;
        int min;
        if (Booleans.isFalse(value)) {
            return FALSE_INSTANCE;
        }
        int dash = value.indexOf(45);
        if (-1 == dash) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash);
        }
        String sMin = value.substring(0, dash);
        try {
            min = Integer.parseInt(sMin);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
        }
        String sMax = value.substring(dash + 1);
        if (sMax.equals(ALL_NODES_VALUE)) {
            max = Integer.MAX_VALUE;
        } else {
            try {
                max = Integer.parseInt(sMax);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [index.auto_expand_replicas] from value: [" + value + "] at index " + dash, e);
            }
        }
        return new AutoExpandReplicas(min, max, true);
    }

    private AutoExpandReplicas(int minReplicas, int maxReplicas, boolean enabled) {
        if (minReplicas > maxReplicas) {
            throw new IllegalArgumentException("[index.auto_expand_replicas] minReplicas must be =< maxReplicas but wasn't " + minReplicas + " > " + maxReplicas);
        }
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
        this.enabled = enabled;
    }

    public int getMinReplicas() {
        return this.minReplicas;
    }

    public int getMaxReplicas(int numDataNodes) {
        return Math.min(this.maxReplicas, numDataNodes - 1);
    }

    private OptionalInt getDesiredNumberOfReplicas(IndexMetadata indexMetaData, RoutingAllocation allocation) {
        if (this.enabled) {
            int numMatchingDataNodes = 0;
            if (allocation.nodes().getMinNodeVersion().onOrAfter(Version.V_4_4_0)) {
                for (ObjectCursor cursor : allocation.nodes().getDataNodes().values()) {
                    Decision decision = allocation.deciders().shouldAutoExpandToNode(indexMetaData, (DiscoveryNode)cursor.value, allocation);
                    if (decision.type() == Decision.Type.NO) continue;
                    ++numMatchingDataNodes;
                }
            } else {
                numMatchingDataNodes = allocation.nodes().getDataNodes().size();
            }
            int min = this.getMinReplicas();
            int max = this.getMaxReplicas(numMatchingDataNodes);
            int numberOfReplicas = numMatchingDataNodes - 1;
            if (numberOfReplicas < min) {
                numberOfReplicas = min;
            } else if (numberOfReplicas > max) {
                numberOfReplicas = max;
            }
            if (numberOfReplicas >= min && numberOfReplicas <= max) {
                return OptionalInt.of(numberOfReplicas);
            }
        }
        return OptionalInt.empty();
    }

    public String toString() {
        return this.enabled ? this.minReplicas + "-" + this.maxReplicas : "false";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static Map<Integer, List<String>> getAutoExpandReplicaChanges(Metadata metadata, RoutingAllocation allocation) {
        HashMap<Integer, List<String>> nrReplicasChanged = new HashMap<Integer, List<String>>();
        for (IndexMetadata indexMetadata : metadata) {
            if (indexMetadata.getState() == IndexMetadata.State.CLOSE) continue;
            AutoExpandReplicas autoExpandReplicas = SETTING.get(indexMetadata.getSettings());
            autoExpandReplicas.getDesiredNumberOfReplicas(indexMetadata, allocation).ifPresent(numberOfReplicas -> {
                if (numberOfReplicas != indexMetadata.getNumberOfReplicas()) {
                    nrReplicasChanged.computeIfAbsent(numberOfReplicas, ArrayList::new).add(indexMetadata.getIndex().getName());
                }
            });
        }
        return nrReplicasChanged;
    }
}

