/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.common.collections.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;

public interface AliasOrIndex {
    public boolean isAlias();

    public List<IndexMetadata> getIndices();

    public static class Alias
    implements AliasOrIndex {
        private final String aliasName;
        private final List<IndexMetadata> referenceIndexMetadatas;
        private SetOnce<IndexMetadata> writeIndex = new SetOnce();

        public Alias(AliasMetadata aliasMetadata, IndexMetadata indexMetadata) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = new ArrayList<IndexMetadata>();
            this.referenceIndexMetadatas.add(indexMetadata);
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return this.referenceIndexMetadatas;
        }

        @Nullable
        public IndexMetadata getWriteIndex() {
            return (IndexMetadata)this.writeIndex.get();
        }

        public Iterable<Tuple<String, AliasMetadata>> getConcreteIndexAndAliasMetadatas() {
            return new Iterable<Tuple<String, AliasMetadata>>(){

                @Override
                public Iterator<Tuple<String, AliasMetadata>> iterator() {
                    return new Iterator<Tuple<String, AliasMetadata>>(){
                        int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < referenceIndexMetadatas.size();
                        }

                        @Override
                        public Tuple<String, AliasMetadata> next() {
                            IndexMetadata indexMetadata = referenceIndexMetadatas.get(this.index++);
                            return new Tuple<String, AliasMetadata>(indexMetadata.getIndex().getName(), indexMetadata.getAliases().get(aliasName));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public AliasMetadata getFirstAliasMetadata() {
            return this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName);
        }

        void addIndex(IndexMetadata indexMetadata) {
            this.referenceIndexMetadatas.add(indexMetadata);
        }

        public void computeAndValidateWriteIndex() {
            List writeIndices = this.referenceIndexMetadatas.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && this.referenceIndexMetadatas.size() == 1 && this.referenceIndexMetadatas.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(this.referenceIndexMetadatas.get(0));
            }
            if (writeIndices.size() == 1) {
                this.writeIndex.set((Object)((IndexMetadata)writeIndices.get(0)));
            } else if (writeIndices.size() > 1) {
                List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
        }
    }

    public static class Index
    implements AliasOrIndex {
        private final IndexMetadata concreteIndex;

        public Index(IndexMetadata indexMetadata) {
            this.concreteIndex = indexMetadata;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        @Override
        public List<IndexMetadata> getIndices() {
            return Collections.singletonList(this.concreteIndex);
        }

        public IndexMetadata getIndex() {
            return this.concreteIndex;
        }
    }
}

