/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class Reconfigurator {
    private static final Logger LOGGER = LogManager.getLogger(Reconfigurator.class);
    public static final Setting<Boolean> CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION = Setting.boolSetting("cluster.auto_shrink_voting_configuration", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean autoShrinkVotingConfiguration;

    public Reconfigurator(Settings settings, ClusterSettings clusterSettings) {
        this.autoShrinkVotingConfiguration = CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION, this::setAutoShrinkVotingConfiguration);
    }

    public void setAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
        this.autoShrinkVotingConfiguration = autoShrinkVotingConfiguration;
    }

    private static int roundDownToOdd(int size) {
        return size - (size % 2 == 0 ? 1 : 0);
    }

    public String toString() {
        return "Reconfigurator{autoShrinkVotingConfiguration=" + this.autoShrinkVotingConfiguration + "}";
    }

    public CoordinationMetadata.VotingConfiguration reconfigure(Set<DiscoveryNode> liveNodes, Set<String> retiredNodeIds, DiscoveryNode currentMaster, CoordinationMetadata.VotingConfiguration currentConfig) {
        assert (liveNodes.contains(currentMaster)) : "liveNodes = " + liveNodes + " master = " + currentMaster;
        LOGGER.trace("{} reconfiguring {} based on liveNodes={}, retiredNodeIds={}, currentMaster={}", (Object)this, (Object)currentConfig, liveNodes, retiredNodeIds, (Object)currentMaster);
        Set<String> liveNodeIds = liveNodes.stream().filter(DiscoveryNode::isMasterNode).map(DiscoveryNode::getId).collect(Collectors.toSet());
        Set<String> currentConfigNodeIds = currentConfig.getNodeIds();
        TreeSet orderedCandidateNodes = new TreeSet();
        liveNodes.stream().filter(DiscoveryNode::isMasterNode).filter(n -> !retiredNodeIds.contains(n.getId())).forEach(n -> orderedCandidateNodes.add(new VotingConfigNode(n.getId(), true, n.getId().equals(currentMaster.getId()), currentConfigNodeIds.contains(n.getId()))));
        currentConfigNodeIds.stream().filter(nid -> !liveNodeIds.contains(nid)).filter(nid -> !retiredNodeIds.contains(nid)).forEach(nid -> orderedCandidateNodes.add(new VotingConfigNode((String)nid, false, false, true)));
        int nonRetiredConfigSize = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.inCurrentConfig).count());
        int minimumConfigEnforcedSize = this.autoShrinkVotingConfiguration ? (nonRetiredConfigSize < 3 ? 1 : 3) : nonRetiredConfigSize;
        int nonRetiredLiveNodeCount = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.live).count());
        int targetSize = Math.max(Reconfigurator.roundDownToOdd(nonRetiredLiveNodeCount), minimumConfigEnforcedSize);
        CoordinationMetadata.VotingConfiguration newConfig = new CoordinationMetadata.VotingConfiguration(orderedCandidateNodes.stream().limit(targetSize).map(n -> n.id).collect(Collectors.toSet()));
        if (newConfig.hasQuorum(liveNodeIds)) {
            return newConfig;
        }
        return currentConfig;
    }

    static class VotingConfigNode
    implements Comparable<VotingConfigNode> {
        final String id;
        final boolean live;
        final boolean currentMaster;
        final boolean inCurrentConfig;

        VotingConfigNode(String id, boolean live, boolean currentMaster, boolean inCurrentConfig) {
            this.id = id;
            this.live = live;
            this.currentMaster = currentMaster;
            this.inCurrentConfig = inCurrentConfig;
        }

        @Override
        public int compareTo(VotingConfigNode other) {
            int currentMasterComp = Boolean.compare(other.currentMaster, this.currentMaster);
            if (currentMasterComp != 0) {
                return currentMasterComp;
            }
            int liveComp = Boolean.compare(other.live, this.live);
            if (liveComp != 0) {
                return liveComp;
            }
            int inCurrentConfigComp = Boolean.compare(other.inCurrentConfig, this.inCurrentConfig);
            if (inCurrentConfigComp != 0) {
                return inCurrentConfigComp;
            }
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return "VotingConfigNode{id='" + this.id + "', live=" + this.live + ", currentMaster=" + this.currentMaster + ", inCurrentConfig=" + this.inCurrentConfig + "}";
        }
    }
}

