/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongConsumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.PreVoteRequest;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class PreVoteCollector {
    private static final Logger LOGGER = LogManager.getLogger(PreVoteCollector.class);
    public static final String REQUEST_PRE_VOTE_ACTION_NAME = "internal:cluster/request_pre_vote";
    private final TransportService transportService;
    private final Runnable startElection;
    private final LongConsumer updateMaxTermSeen;
    private volatile Tuple<DiscoveryNode, PreVoteResponse> state;

    PreVoteCollector(TransportService transportService, Runnable startElection, LongConsumer updateMaxTermSeen) {
        this.transportService = transportService;
        this.startElection = startElection;
        this.updateMaxTermSeen = updateMaxTermSeen;
        transportService.registerRequestHandler(REQUEST_PRE_VOTE_ACTION_NAME, "generic", false, false, PreVoteRequest::new, (request, channel, task) -> channel.sendResponse(this.handlePreVoteRequest((PreVoteRequest)request)));
    }

    public Releasable start(ClusterState clusterState, Iterable<DiscoveryNode> broadcastNodes) {
        PreVotingRound preVotingRound = new PreVotingRound(clusterState, this.state.v2().getCurrentTerm());
        preVotingRound.start(broadcastNodes);
        return preVotingRound;
    }

    PreVoteResponse getPreVoteResponse() {
        return this.state.v2();
    }

    @Nullable
    DiscoveryNode getLeader() {
        return this.state.v1();
    }

    public void update(PreVoteResponse preVoteResponse, @Nullable DiscoveryNode leader) {
        LOGGER.trace("updating with preVoteResponse={}, leader={}", (Object)preVoteResponse, (Object)leader);
        this.state = new Tuple<DiscoveryNode, PreVoteResponse>(leader, preVoteResponse);
    }

    private PreVoteResponse handlePreVoteRequest(PreVoteRequest request) {
        this.updateMaxTermSeen.accept(request.getCurrentTerm());
        Tuple<DiscoveryNode, PreVoteResponse> state = this.state;
        assert (state != null) : "received pre-vote request before fully initialised";
        DiscoveryNode leader = state.v1();
        PreVoteResponse response = state.v2();
        if (leader == null) {
            return response;
        }
        if (leader.equals(request.getSourceNode())) {
            return response;
        }
        throw new CoordinationStateRejectedException("rejecting " + request + " as there is already a leader", new Object[0]);
    }

    public String toString() {
        return "PreVoteCollector{state=" + this.state + "}";
    }

    private class PreVotingRound
    implements Releasable {
        private final Set<DiscoveryNode> preVotesReceived = ConcurrentCollections.newConcurrentSet();
        private final AtomicBoolean electionStarted = new AtomicBoolean();
        private final PreVoteRequest preVoteRequest;
        private final ClusterState clusterState;
        private final AtomicBoolean isClosed = new AtomicBoolean();

        PreVotingRound(ClusterState clusterState, long currentTerm) {
            this.clusterState = clusterState;
            this.preVoteRequest = new PreVoteRequest(PreVoteCollector.this.transportService.getLocalNode(), currentTerm);
        }

        void start(Iterable<DiscoveryNode> broadcastNodes) {
            LOGGER.debug("{} requesting pre-votes from {}", (Object)this, broadcastNodes);
            broadcastNodes.forEach(n -> PreVoteCollector.this.transportService.sendRequest((DiscoveryNode)n, PreVoteCollector.REQUEST_PRE_VOTE_ACTION_NAME, this.preVoteRequest, new TransportResponseHandler<PreVoteResponse>(){

                @Override
                public PreVoteResponse read(StreamInput in) throws IOException {
                    return new PreVoteResponse(in);
                }

                @Override
                public void handleResponse(PreVoteResponse response) {
                    PreVotingRound.this.handlePreVoteResponse(response, n);
                }

                @Override
                public void handleException(TransportException exp) {
                    LOGGER.debug((Message)new ParameterizedMessage("{} failed", (Object)this), (Throwable)exp);
                }

                @Override
                public String executor() {
                    return "generic";
                }

                public String toString() {
                    return "TransportResponseHandler{" + PreVoteCollector.this + ", node=" + n + "}";
                }
            }));
        }

        private void handlePreVoteResponse(PreVoteResponse response, DiscoveryNode sender) {
            if (this.isClosed.get()) {
                LOGGER.debug("{} is closed, ignoring {} from {}", (Object)this, (Object)response, (Object)sender);
                return;
            }
            PreVoteCollector.this.updateMaxTermSeen.accept(response.getCurrentTerm());
            if (response.getLastAcceptedTerm() > this.clusterState.term() || response.getLastAcceptedTerm() == this.clusterState.term() && response.getLastAcceptedVersion() > this.clusterState.version()) {
                LOGGER.debug("{} ignoring {} from {} as it is fresher", (Object)this, (Object)response, (Object)sender);
                return;
            }
            this.preVotesReceived.add(sender);
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            this.preVotesReceived.forEach(voteCollection::addVote);
            if (!CoordinationState.isElectionQuorum(voteCollection, this.clusterState)) {
                LOGGER.debug("{} added {} from {}, no quorum yet", (Object)this, (Object)response, (Object)sender);
                return;
            }
            if (!this.electionStarted.compareAndSet(false, true)) {
                LOGGER.debug("{} added {} from {} but election has already started", (Object)this, (Object)response, (Object)sender);
                return;
            }
            LOGGER.debug("{} added {} from {}, starting election", (Object)this, (Object)response, (Object)sender);
            PreVoteCollector.this.startElection.run();
        }

        public String toString() {
            return "PreVotingRound{preVotesReceived=" + this.preVotesReceived + ", electionStarted=" + this.electionStarted + ", preVoteRequest=" + this.preVoteRequest + ", isClosed=" + this.isClosed + "}";
        }

        @Override
        public void close() {
            boolean isNotAlreadyClosed = this.isClosed.compareAndSet(false, true);
            assert (isNotAlreadyClosed);
        }
    }
}

