/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.nio.file.Path;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.env.Environment;

public class DetachClusterCommand
extends ElasticsearchNodeCommand {
    public static final String NODE_DETACHED_MSG = "Node was successfully detached from the cluster";
    public static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have permanently lost all of the\nmaster-eligible nodes in this cluster and you cannot restore the cluster\nfrom a snapshot, or you have already unsafely bootstrapped a new cluster\nby running `crate-node unsafe-bootstrap` on a master-eligible\nnode that belonged to the same cluster as this node. This tool can cause\narbitrary data loss and its use should be your last resort.\n\nDo you want to proceed?\n";

    public DetachClusterCommand() {
        super("Detaches this node from its cluster, allowing it to unsafely join a new cluster");
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, Environment env) throws IOException {
        Tuple<Manifest, Metadata> manifestMetadataTuple = this.loadMetadata(terminal, dataPaths);
        Manifest manifest = manifestMetadataTuple.v1();
        Metadata metadata = manifestMetadataTuple.v2();
        this.confirm(terminal, CONFIRMATION_MSG);
        this.writeNewMetadata(terminal, manifest, DetachClusterCommand.updateCurrentTerm(), metadata, DetachClusterCommand.updateMetadata(metadata), dataPaths);
        terminal.println(NODE_DETACHED_MSG);
    }

    static Metadata updateMetadata(Metadata oldMetadata) {
        CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder().lastAcceptedConfiguration(CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_MASTER).lastCommittedConfiguration(CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_MASTER).term(0L).build();
        return Metadata.builder(oldMetadata).coordinationMetadata(coordinationMetadata).clusterUUIDCommitted(false).build();
    }

    static long updateCurrentTerm() {
        return 0L;
    }
}

