/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "snapshots";
    private final List<Entry> entries;
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String PARTIAL = "partial";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String START_TIME = "start_time";
    private static final String REPOSITORY_STATE_ID = "repository_state_id";
    private static final String SHARDS = "shards";
    private static final String INDEX = "index";
    private static final String SHARD = "shard";
    private static final String NODE = "node";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsInProgress that = (SnapshotsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static boolean completed(ObjectContainer<ShardSnapshotStatus> shards) {
        for (ObjectCursor status : shards) {
            if (((ShardSnapshotStatus)status.value).state().completed) continue;
            return false;
        }
        return true;
    }

    public SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    public SnapshotsInProgress(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getWriteableName() {
        return "snapshots";
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, "snapshots", in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            Snapshot snapshot = new Snapshot(in);
            boolean includeGlobalState = in.readBoolean();
            boolean partial = in.readBoolean();
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<IndexId> indexBuilder = new ArrayList<IndexId>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(new IndexId(in.readString(), in.readString()));
            }
            long startTime = in.readLong();
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = new ShardId(in);
                builder.put(shardId, new ShardSnapshotStatus(in));
            }
            long repositoryStateId = in.readLong();
            String failure = in.readOptionalString();
            boolean useShardGenerations = in.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION) ? in.readBoolean() : false;
            entries[i] = new Entry(snapshot, includeGlobalState, partial, state, Collections.unmodifiableList(indexBuilder), startTime, repositoryStateId, builder.build(), failure, useShardGenerations);
        }
        this.entries = Arrays.asList(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshot().writeTo(out);
            out.writeBoolean(entry.includeGlobalState());
            out.writeBoolean(entry.partial());
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (IndexId indexId : entry.indices()) {
                indexId.writeTo(out);
            }
            out.writeLong(entry.startTime());
            out.writeVInt(entry.shards().size());
            for (ObjectObjectCursor objectObjectCursor : entry.shards()) {
                ((ShardId)objectObjectCursor.key).writeTo(out);
                ((ShardSnapshotStatus)objectObjectCursor.value).writeTo(out);
            }
            out.writeLong(entry.repositoryStateId);
            out.writeOptionalString(entry.failure);
            if (!out.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) continue;
            out.writeBoolean(entry.useShardGenerations);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            this.toXContent(entry, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REPOSITORY, entry.snapshot().getRepository());
        builder.field(SNAPSHOT, entry.snapshot().getSnapshotId().getName());
        builder.field(UUID, entry.snapshot().getSnapshotId().getUUID());
        builder.field(INCLUDE_GLOBAL_STATE, entry.includeGlobalState());
        builder.field(PARTIAL, entry.partial());
        builder.field(STATE, (Object)entry.state());
        builder.startArray(INDICES);
        for (IndexId indexId : entry.indices()) {
            indexId.toXContent(builder, params);
        }
        builder.endArray();
        builder.humanReadableField(START_TIME_MILLIS, START_TIME, new TimeValue(entry.startTime()));
        builder.field(REPOSITORY_STATE_ID, entry.getRepositoryStateId());
        builder.startArray(SHARDS);
        for (ObjectObjectCursor objectObjectCursor : entry.shards) {
            ShardId shardId = (ShardId)objectObjectCursor.key;
            ShardSnapshotStatus status = (ShardSnapshotStatus)objectObjectCursor.value;
            builder.startObject();
            builder.field(INDEX, shardId.getIndex());
            builder.field(SHARD, shardId.getId());
            builder.field(STATE, (Object)status.state());
            builder.field(NODE, status.nodeId());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public static class Entry {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final ImmutableOpenMap<String, List<ShardId>> waitingIndices;
        private final long startTime;
        private final long repositoryStateId;
        private final boolean useShardGenerations;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure, boolean useShardGenerations) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.startTime = startTime;
            if (shards == null) {
                this.shards = ImmutableOpenMap.of();
                this.waitingIndices = ImmutableOpenMap.of();
            } else {
                this.shards = shards;
                this.waitingIndices = this.findWaitingIndices(shards);
                assert (Entry.assertShardsConsistent(state, indices, shards));
            }
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.useShardGenerations = useShardGenerations;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, boolean useShardGenerations) {
            this(snapshot, includeGlobalState, partial, state, indices, startTime, repositoryStateId, shards, null, useShardGenerations);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.startTime, entry.repositoryStateId, shards, entry.failure, entry.useShardGenerations);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.startTime, entry.repositoryStateId, shards, failure, entry.useShardGenerations);
        }

        public Entry(Entry entry, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry, entry.state, shards, entry.failure);
        }

        private static boolean assertShardsConsistent(State state, List<IndexId> indices, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            Set indexNames = indices.stream().map(IndexId::getName).collect(Collectors.toSet());
            HashSet indexNamesInShards = new HashSet();
            shards.keysIt().forEachRemaining(s -> indexNamesInShards.add(s.getIndexName()));
            assert (indexNames.equals(indexNamesInShards)) : "Indices in shards " + indexNamesInShards + " differ from expected indices " + indexNames + " for state [" + state + "]";
            return true;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public ImmutableOpenMap<String, List<ShardId>> waitingIndices() {
            return this.waitingIndices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public long getRepositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public boolean useShardGenerations() {
            return this.useShardGenerations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            return this.useShardGenerations == entry.useShardGenerations;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + (this.useShardGenerations ? 1 : 0);
            return result;
        }

        public String toString() {
            return this.snapshot.toString();
        }

        private ImmutableOpenMap<String, List<ShardId>> findWaitingIndices(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            HashMap<String, List> waitingIndicesMap = new HashMap<String, List>();
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : shards) {
                if (((ShardSnapshotStatus)objectObjectCursor.value).state() != ShardState.WAITING) continue;
                waitingIndicesMap.computeIfAbsent(((ShardId)objectObjectCursor.key).getIndexName(), k -> new ArrayList()).add((ShardId)objectObjectCursor.key);
            }
            if (waitingIndicesMap.isEmpty()) {
                return ImmutableOpenMap.of();
            }
            ImmutableOpenMap.Builder waitingIndicesBuilder = ImmutableOpenMap.builder();
            for (Map.Entry entry : waitingIndicesMap.entrySet()) {
                waitingIndicesBuilder.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
            return waitingIndicesBuilder.build();
        }
    }

    public static class ShardSnapshotStatus {
        private final ShardState state;
        private final String nodeId;
        private final String reason;
        @Nullable
        private final String generation;

        public ShardSnapshotStatus(String nodeId, String generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(String nodeId, ShardState state, String generation) {
            this(nodeId, state, null, generation);
        }

        public ShardSnapshotStatus(String nodeId, ShardState state, String reason, String generation) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            assert (!state.failed() || reason != null);
            this.generation = generation;
        }

        public ShardSnapshotStatus(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = ShardState.fromValue(in.readByte());
            if (in.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) {
                this.generation = in.readOptionalString();
                assert (this.generation != null || this.state != ShardState.SUCCESS) : "Received null generation for shard state [" + this.state + "]";
            } else {
                this.generation = null;
            }
            this.reason = in.readOptionalString();
        }

        public ShardState state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        @Nullable
        public String generation() {
            return this.generation;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            if (out.getVersion().onOrAfter(SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION)) {
                out.writeOptionalString(this.generation);
            }
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            return Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason) && Objects.equals(this.generation, status.generation) && this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.generation != null ? this.generation.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + this.state + ", nodeId=" + this.nodeId + ", reason=" + this.reason + ", generation=" + this.generation + "]";
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
            }
            throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
        }
    }

    public static enum State {
        INIT(0, false, false),
        STARTED(1, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private State(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }
}

