/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.support;

import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryAction;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequestBuilder;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksAction;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeAction;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public abstract class AbstractClient
implements Client {
    private final ThreadPool threadPool;
    private final Admin admin;
    private final Settings settings;

    public AbstractClient(Settings settings, ThreadPool threadPool) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.admin = new Admin(this);
    }

    @Override
    public final Settings settings() {
        return this.settings;
    }

    @Override
    public final ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public final AdminClient admin() {
        return this.admin;
    }

    @Override
    public final <Request extends TransportRequest, Response extends TransportResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
        PlainActionFuture actionFuture = PlainActionFuture.newFuture();
        this.execute(action, request, actionFuture);
        return actionFuture;
    }

    @Override
    public final <Request extends TransportRequest, Response extends TransportResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.doExecute(action, request, listener);
    }

    protected abstract <Request extends TransportRequest, Response extends TransportResponse> void doExecute(ActionType<Response> var1, Request var2, ActionListener<Response> var3);

    static class Admin
    implements AdminClient {
        private final ClusterAdmin clusterAdmin;
        private final IndicesAdmin indicesAdmin;

        Admin(ElasticsearchClient client) {
            this.clusterAdmin = new ClusterAdmin(client);
            this.indicesAdmin = new IndicesAdmin(client);
        }

        @Override
        public ClusterAdminClient cluster() {
            return this.clusterAdmin;
        }

        @Override
        public IndicesAdminClient indices() {
            return this.indicesAdmin;
        }
    }

    static class IndicesAdmin
    implements IndicesAdminClient {
        private final ElasticsearchClient client;

        IndicesAdmin(ElasticsearchClient client) {
            this.client = client;
        }

        @Override
        public <Request extends TransportRequest, Response extends TransportResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
            return this.client.execute(action, request);
        }

        @Override
        public <Request extends TransportRequest, Response extends TransportResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            this.client.execute(action, request, listener);
        }

        @Override
        public ThreadPool threadPool() {
            return this.client.threadPool();
        }

        @Override
        public ActionFuture<CreateIndexResponse> create(CreateIndexRequest request) {
            return this.execute(CreateIndexAction.INSTANCE, request);
        }

        @Override
        public void create(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
            this.execute(CreateIndexAction.INSTANCE, request, listener);
        }

        @Override
        public CreateIndexRequestBuilder prepareCreate(String index) {
            return new CreateIndexRequestBuilder((ElasticsearchClient)this, CreateIndexAction.INSTANCE, index);
        }

        @Override
        public ActionFuture<AcknowledgedResponse> delete(DeleteIndexRequest request) {
            return this.execute(DeleteIndexAction.INSTANCE, request);
        }

        @Override
        public void delete(DeleteIndexRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.execute(DeleteIndexAction.INSTANCE, request, listener);
        }

        @Override
        public DeleteIndexRequestBuilder prepareDelete(String ... indices) {
            return new DeleteIndexRequestBuilder((ElasticsearchClient)this, DeleteIndexAction.INSTANCE, indices);
        }

        @Override
        public ActionFuture<AcknowledgedResponse> putMapping(PutMappingRequest request) {
            return this.execute(PutMappingAction.INSTANCE, request);
        }

        @Override
        public void putMapping(PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.execute(PutMappingAction.INSTANCE, request, listener);
        }

        @Override
        public PutMappingRequestBuilder preparePutMapping(String ... indices) {
            return new PutMappingRequestBuilder(this, PutMappingAction.INSTANCE).setIndices(indices);
        }

        @Override
        public ActionFuture<ForceMergeResponse> forceMerge(ForceMergeRequest request) {
            return this.execute(ForceMergeAction.INSTANCE, request);
        }

        @Override
        public void forceMerge(ForceMergeRequest request, ActionListener<ForceMergeResponse> listener) {
            this.execute(ForceMergeAction.INSTANCE, request, listener);
        }

        @Override
        public ForceMergeRequestBuilder prepareForceMerge(String ... indices) {
            return (ForceMergeRequestBuilder)new ForceMergeRequestBuilder(this, ForceMergeAction.INSTANCE).setIndices(indices);
        }

        @Override
        public ActionFuture<UpgradeResponse> upgrade(UpgradeRequest request) {
            return this.execute(UpgradeAction.INSTANCE, request);
        }

        @Override
        public void upgrade(UpgradeRequest request, ActionListener<UpgradeResponse> listener) {
            this.execute(UpgradeAction.INSTANCE, request, listener);
        }

        @Override
        public ActionFuture<RefreshResponse> refresh(RefreshRequest request) {
            return this.execute(RefreshAction.INSTANCE, request);
        }

        @Override
        public void refresh(RefreshRequest request, ActionListener<RefreshResponse> listener) {
            this.execute(RefreshAction.INSTANCE, request, listener);
        }

        @Override
        public RefreshRequestBuilder prepareRefresh(String ... indices) {
            return (RefreshRequestBuilder)new RefreshRequestBuilder(this, RefreshAction.INSTANCE).setIndices(indices);
        }

        @Override
        public ActionFuture<IndicesStatsResponse> stats(IndicesStatsRequest request) {
            return this.execute(IndicesStatsAction.INSTANCE, request);
        }

        @Override
        public void stats(IndicesStatsRequest request, ActionListener<IndicesStatsResponse> listener) {
            this.execute(IndicesStatsAction.INSTANCE, request, listener);
        }

        @Override
        public IndicesStatsRequestBuilder prepareStats(String ... indices) {
            return (IndicesStatsRequestBuilder)new IndicesStatsRequestBuilder(this, IndicesStatsAction.INSTANCE).setIndices(indices);
        }

        @Override
        public ActionFuture<RecoveryResponse> recoveries(RecoveryRequest request) {
            return this.execute(RecoveryAction.INSTANCE, request);
        }

        @Override
        public void recoveries(RecoveryRequest request, ActionListener<RecoveryResponse> listener) {
            this.execute(RecoveryAction.INSTANCE, request, listener);
        }

        @Override
        public ActionFuture<AcknowledgedResponse> updateSettings(UpdateSettingsRequest request) {
            return this.execute(UpdateSettingsAction.INSTANCE, request);
        }

        @Override
        public void updateSettings(UpdateSettingsRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.execute(UpdateSettingsAction.INSTANCE, request, listener);
        }

        @Override
        public UpdateSettingsRequestBuilder prepareUpdateSettings(String ... indices) {
            return new UpdateSettingsRequestBuilder((ElasticsearchClient)this, UpdateSettingsAction.INSTANCE, new String[0]).setIndices(indices);
        }

        @Override
        public ActionFuture<AcknowledgedResponse> putTemplate(PutIndexTemplateRequest request) {
            return this.execute(PutIndexTemplateAction.INSTANCE, request);
        }

        @Override
        public void putTemplate(PutIndexTemplateRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.execute(PutIndexTemplateAction.INSTANCE, request, listener);
        }

        @Override
        public PutIndexTemplateRequestBuilder preparePutTemplate(String name) {
            return new PutIndexTemplateRequestBuilder((ElasticsearchClient)this, PutIndexTemplateAction.INSTANCE, name);
        }

        @Override
        public ActionFuture<GetIndexTemplatesResponse> getTemplates(GetIndexTemplatesRequest request) {
            return this.execute(GetIndexTemplatesAction.INSTANCE, request);
        }

        @Override
        public void getTemplates(GetIndexTemplatesRequest request, ActionListener<GetIndexTemplatesResponse> listener) {
            this.execute(GetIndexTemplatesAction.INSTANCE, request, listener);
        }

        @Override
        public GetIndexTemplatesRequestBuilder prepareGetTemplates(String ... names) {
            return new GetIndexTemplatesRequestBuilder((ElasticsearchClient)this, GetIndexTemplatesAction.INSTANCE, names);
        }

        @Override
        public void deleteTemplate(DeleteIndexTemplateRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.execute(DeleteIndexTemplateAction.INSTANCE, request, listener);
        }

        @Override
        public DeleteIndexTemplateRequestBuilder prepareDeleteTemplate(String name) {
            return new DeleteIndexTemplateRequestBuilder((ElasticsearchClient)this, DeleteIndexTemplateAction.INSTANCE, name);
        }
    }

    static class ClusterAdmin
    implements ClusterAdminClient {
        private final ElasticsearchClient client;

        ClusterAdmin(ElasticsearchClient client) {
            this.client = client;
        }

        @Override
        public <Request extends TransportRequest, Response extends TransportResponse> ActionFuture<Response> execute(ActionType<Response> action, Request request) {
            return this.client.execute(action, request);
        }

        @Override
        public <Request extends TransportRequest, Response extends TransportResponse> void execute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
            this.client.execute(action, request, listener);
        }

        @Override
        public ThreadPool threadPool() {
            return this.client.threadPool();
        }

        @Override
        public ActionFuture<ClusterHealthResponse> health(ClusterHealthRequest request) {
            return this.execute(ClusterHealthAction.INSTANCE, request);
        }

        @Override
        public ClusterHealthRequestBuilder prepareHealth(String ... indices) {
            return new ClusterHealthRequestBuilder(this, ClusterHealthAction.INSTANCE).setIndices(indices);
        }

        @Override
        public ActionFuture<ClusterStateResponse> state(ClusterStateRequest request) {
            return this.execute(ClusterStateAction.INSTANCE, request);
        }

        @Override
        public ClusterStateRequestBuilder prepareState() {
            return new ClusterStateRequestBuilder(this, ClusterStateAction.INSTANCE);
        }

        @Override
        public ClusterRerouteRequestBuilder prepareReroute() {
            return new ClusterRerouteRequestBuilder(this, ClusterRerouteAction.INSTANCE);
        }

        @Override
        public ClusterUpdateSettingsRequestBuilder prepareUpdateSettings() {
            return new ClusterUpdateSettingsRequestBuilder(this, ClusterUpdateSettingsAction.INSTANCE);
        }

        @Override
        public PendingClusterTasksRequestBuilder preparePendingClusterTasks() {
            return new PendingClusterTasksRequestBuilder(this, PendingClusterTasksAction.INSTANCE);
        }

        @Override
        public PutRepositoryRequestBuilder preparePutRepository(String name) {
            return new PutRepositoryRequestBuilder((ElasticsearchClient)this, PutRepositoryAction.INSTANCE, name);
        }

        @Override
        public CreateSnapshotRequestBuilder prepareCreateSnapshot(String repository, String name) {
            return new CreateSnapshotRequestBuilder(this, CreateSnapshotAction.INSTANCE, repository, name);
        }

        @Override
        public GetSnapshotsRequestBuilder prepareGetSnapshots(String repository) {
            return new GetSnapshotsRequestBuilder((ElasticsearchClient)this, GetSnapshotsAction.INSTANCE, repository);
        }

        @Override
        public DeleteSnapshotRequestBuilder prepareDeleteSnapshot(String repository, String name) {
            return new DeleteSnapshotRequestBuilder(this, DeleteSnapshotAction.INSTANCE, repository, name);
        }

        @Override
        public DeleteRepositoryRequestBuilder prepareDeleteRepository(String name) {
            return new DeleteRepositoryRequestBuilder((ElasticsearchClient)this, DeleteRepositoryAction.INSTANCE, name);
        }

        @Override
        public void nodesStats(NodesStatsRequest request, ActionListener<NodesStatsResponse> listener) {
            this.execute(NodesStatsAction.INSTANCE, request, listener);
        }
    }
}

