/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public class NodeClient
extends AbstractClient {
    private Map<ActionType, TransportAction> actions;

    public NodeClient(Settings settings, ThreadPool threadPool) {
        super(settings, threadPool);
    }

    public void initialize(Map<ActionType, TransportAction> actions) {
        this.actions = actions;
    }

    @Override
    public void close() {
    }

    @Override
    public <Request extends TransportRequest, Response extends TransportResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.executeLocally(action, request, listener);
    }

    public <Request extends TransportRequest, Response extends TransportResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        return this.transportAction(action).execute(request, listener);
    }

    private <Request extends TransportRequest, Response extends TransportResponse> TransportAction<Request, Response> transportAction(ActionType<Response> action) {
        if (this.actions == null) {
            throw new IllegalStateException("NodeClient has not been initialized");
        }
        TransportAction transportAction = this.actions.get(action);
        if (transportAction == null) {
            throw new IllegalStateException("failed to find action [" + action + "] to execute");
        }
        return transportAction;
    }
}

