/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionSet;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;

public class MultiCommand
extends Command {
    protected final Map<String, Command> subcommands = new LinkedHashMap<String, Command>();
    private final NonOptionArgumentSpec<String> arguments = this.parser.nonOptions("command");

    public MultiCommand(String description, Runnable beforeMain) {
        super(description, beforeMain);
        this.parser.posixlyCorrect(true);
    }

    @Override
    protected void printAdditionalHelp(Terminal terminal) {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        terminal.println("Commands");
        terminal.println("--------");
        for (Map.Entry<String, Command> subcommand : this.subcommands.entrySet()) {
            terminal.println(subcommand.getKey() + " - " + subcommand.getValue().description);
        }
        terminal.println("");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        String[] args = this.arguments.values(options).toArray(new String[0]);
        if (args.length == 0) {
            throw new UserException(64, "Missing command");
        }
        Command subcommand = this.subcommands.get(args[0]);
        if (subcommand == null) {
            throw new UserException(64, "Unknown command [" + args[0] + "]");
        }
        subcommand.mainWithoutErrorHandling(Arrays.copyOfRange(args, 1, args.length), terminal);
    }

    @Override
    public void close() throws IOException {
        MultiCommand.close(this.subcommands.values());
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        MultiCommand.close(null, objects);
    }

    public static void close(Exception ex, Iterable<? extends Closeable> objects) throws IOException {
        Exception firstException = ex;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException | RuntimeException e) {
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            if (firstException instanceof IOException) {
                throw (IOException)firstException;
            }
            throw (RuntimeException)firstException;
        }
    }
}

