/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNANatives;

final class Natives {
    private static final Logger LOGGER = LogManager.getLogger(Natives.class);
    static final boolean JNA_AVAILABLE;

    private Natives() {
    }

    static void tryMlockall() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot mlockall because JNA is not available");
            return;
        }
        JNANatives.tryMlockall();
    }

    static boolean definitelyRunningAsRoot() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot check if running as root because JNA is not available");
            return false;
        }
        return JNANatives.definitelyRunningAsRoot();
    }

    static void tryVirtualLock() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot virtual lock because JNA is not available");
            return;
        }
        JNANatives.tryVirtualLock();
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot register console handler because JNA is not available");
            return;
        }
        JNANatives.addConsoleCtrlHandler(handler);
    }

    static boolean isMemoryLocked() {
        if (!JNA_AVAILABLE) {
            return false;
        }
        return JNANatives.LOCAL_MLOCKALL;
    }

    static void trySetMaxNumberOfThreads() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot getrlimit RLIMIT_NPROC because JNA is not available");
            return;
        }
        JNANatives.trySetMaxNumberOfThreads();
    }

    static void trySetMaxSizeVirtualMemory() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot getrlimit RLIMIT_AS because JNA is not available");
            return;
        }
        JNANatives.trySetMaxSizeVirtualMemory();
    }

    static void trySetMaxFileSize() {
        if (!JNA_AVAILABLE) {
            LOGGER.warn("cannot getrlimit RLIMIT_FSIZE because JNA is not available");
            return;
        }
        JNANatives.trySetMaxFileSize();
    }

    static {
        boolean v = false;
        try {
            Class.forName("com.sun.jna.Native");
            v = true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("JNA not found. native methods will be disabled.", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("unable to load JNA native support library, native methods will be disabled.", (Throwable)e);
        }
        JNA_AVAILABLE = v;
    }
}

