/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import io.crate.bootstrap.BootstrapException;
import io.crate.common.SuppressForbidden;
import io.crate.node.CrateNode;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapChecks;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.BootstrapSettings;
import org.elasticsearch.bootstrap.ElasticsearchUncaughtExceptionHandler;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.bootstrap.Natives;
import org.elasticsearch.bootstrap.StartupException;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.PidFile;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.IfConfig;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;

public class BootstrapProxy {
    private static volatile BootstrapProxy INSTANCE;
    private volatile CrateNode node;
    private final CountDownLatch keepAliveLatch = new CountDownLatch(1);
    private final Thread keepAliveThread = new Thread(() -> {
        try {
            this.keepAliveLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }, "crate[keepAlive/" + Version.CURRENT + "]");

    BootstrapProxy() {
        this.keepAliveThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(this.keepAliveLatch::countDown));
    }

    static void initializeNatives(boolean mlockAll, boolean ctrlHandler) {
        Logger logger = LogManager.getLogger(BootstrapProxy.class);
        if (Natives.definitelyRunningAsRoot()) {
            throw new RuntimeException("can not run crate as root");
        }
        if (mlockAll) {
            if (Constants.WINDOWS) {
                Natives.tryVirtualLock();
            } else {
                Natives.tryMlockall();
            }
        }
        if (ctrlHandler) {
            Natives.addConsoleCtrlHandler(code -> {
                if (2 == code) {
                    logger.info("running graceful exit on windows");
                    try {
                        BootstrapProxy.stop();
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("failed to stop node", (Throwable)e, new Object[0]);
                    }
                    return true;
                }
                return false;
            });
        }
        try {
            JNAKernel32Library.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Natives.trySetMaxNumberOfThreads();
        Natives.trySetMaxSizeVirtualMemory();
        Natives.trySetMaxFileSize();
        StringHelper.randomId();
    }

    static void initializeProbes() {
        ProcessProbe.getInstance();
        OsProbe.getInstance();
        JvmInfo.jvmInfo();
    }

    private void setup(boolean addShutdownHook, Environment environment) throws BootstrapException {
        final Settings settings = environment.settings();
        BootstrapProxy.initializeNatives(BootstrapSettings.MEMORY_LOCK_SETTING.get(settings), BootstrapSettings.CTRLHANDLER_SETTING.get(settings));
        BootstrapProxy.initializeProbes();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.node});
                    LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                    Configurator.shutdown((LoggerContext)context);
                    if (this.node != null && !this.node.awaitClose(10L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
                    }
                }
                catch (IOException ex) {
                    throw new ElasticsearchException("failed to stop node", (Throwable)ex, new Object[0]);
                }
                catch (InterruptedException e) {
                    LogManager.getLogger(BootstrapProxy.class).warn("Thread got interrupted while waiting for the node to shutdown.");
                    Thread.currentThread().interrupt();
                }
            }));
        }
        try {
            Logger logger = LogManager.getLogger(JarHell.class);
            JarHell.checkJarHell(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        catch (IOException | URISyntaxException e) {
            throw new BootstrapException(e);
        }
        IfConfig.logIfNecessary();
        this.node = new CrateNode(environment){

            @Override
            protected void validateNodeBeforeAcceptingRequests(BoundTransportAddress boundTransportAddress, List<BootstrapCheck> bootstrapChecks) throws NodeValidationException {
                BootstrapChecks.check(settings, boundTransportAddress, bootstrapChecks);
            }
        };
    }

    private void start() throws NodeValidationException {
        this.node.start();
        this.keepAliveThread.start();
    }

    public static void stop() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{BootstrapProxy.INSTANCE.node});
            if (BootstrapProxy.INSTANCE.node != null && !BootstrapProxy.INSTANCE.node.awaitClose(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Node didn't stop within 10 seconds. Any outstanding requests or tasks might get killed.");
            }
        }
        catch (InterruptedException e) {
            LogManager.getLogger(BootstrapProxy.class).warn("Thread got interrupted while waiting for the node to shutdown.");
            Thread.currentThread().interrupt();
        }
        finally {
            BootstrapProxy.INSTANCE.keepAliveLatch.countDown();
        }
    }

    public static void init(boolean foreground, boolean quiet, Environment environment) throws BootstrapException, NodeValidationException, UserException {
        BootstrapInfo.init();
        INSTANCE = new BootstrapProxy();
        LogConfigurator.setNodeName(Node.NODE_NAME_SETTING.get(environment.settings()));
        try {
            LogConfigurator.configure(environment);
        }
        catch (IOException e) {
            throw new BootstrapException(e);
        }
        if (environment.pidFile() != null) {
            try {
                PidFile.create(environment.pidFile(), true);
            }
            catch (IOException e) {
                throw new BootstrapException(e);
            }
        }
        boolean closeStandardStreams = !foreground || quiet;
        try {
            if (closeStandardStreams) {
                Logger rootLogger = LogManager.getRootLogger();
                Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
                if (maybeConsoleAppender != null) {
                    Loggers.removeAppender(rootLogger, maybeConsoleAppender);
                }
                BootstrapProxy.closeSystOut();
            }
            BootstrapProxy.checkLucene();
            Thread.setDefaultUncaughtExceptionHandler(new ElasticsearchUncaughtExceptionHandler());
            INSTANCE.setup(true, environment);
            INSTANCE.start();
            if (closeStandardStreams) {
                BootstrapProxy.closeSysError();
            }
        }
        catch (RuntimeException | NodeValidationException e) {
            Logger rootLogger = LogManager.getRootLogger();
            Appender maybeConsoleAppender = Loggers.findAppender(rootLogger, ConsoleAppender.class);
            if (foreground && maybeConsoleAppender != null) {
                Loggers.removeAppender(rootLogger, maybeConsoleAppender);
            }
            Logger logger = LogManager.getLogger(BootstrapProxy.class);
            if (e instanceof CreationException) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = null;
                ps = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8);
                new StartupException(e).printStackTrace(ps);
                ps.flush();
                logger.error("Guice Exception: {}", (Object)os.toString(StandardCharsets.UTF_8));
            } else if (e instanceof NodeValidationException) {
                logger.error("node validation exception\n{}", (Object)e.getMessage());
            } else {
                logger.error("Exception", (Throwable)e);
            }
            if (foreground && maybeConsoleAppender != null) {
                Loggers.addAppender(rootLogger, maybeConsoleAppender);
            }
            throw e;
        }
    }

    @SuppressForbidden(reason="System#out")
    private static void closeSystOut() {
        System.out.close();
    }

    @SuppressForbidden(reason="System#err")
    private static void closeSysError() {
        System.err.close();
    }

    @SuppressForbidden(reason="Allowed to exit explicitly in bootstrap phase")
    private static void exit(int status) {
        System.exit(status);
    }

    private static void checkLucene() {
        if (!Version.CURRENT.luceneVersion.equals((Object)org.apache.lucene.util.Version.LATEST)) {
            throw new AssertionError((Object)("Lucene version mismatch this version of CrateDB requires lucene version [" + Version.CURRENT.luceneVersion + "]  but the current lucene version is [" + org.apache.lucene.util.Version.LATEST + "]"));
        }
    }
}

