/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.elasticsearch.analysis.common.CharMatcher;
import org.elasticsearch.analysis.common.NGramTokenizerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;

    EdgeNGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", 1);
        this.maxGram = settings.getAsInt("max_gram", 2);
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsList("token_chars"));
    }

    @Override
    public Tokenizer create() {
        if (this.matcher == null) {
            return new EdgeNGramTokenizer(this.minGram, this.maxGram);
        }
        return new EdgeNGramTokenizer(this.minGram, this.maxGram){

            protected boolean isTokenChar(int chr) {
                return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }
}

