/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.bn.BengaliAnalyzer;
import org.apache.lucene.analysis.bn.BengaliNormalizationFilter;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniNormalizationFilter;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.UpperCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hi.HindiNormalizationFilter;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.in.IndicNormalizationFilter;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.ScandinavianNormalizationFilter;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.TypeAsPayloadTokenFilter;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.reverse.ReverseStringFilter;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tr.ApostropheFilter;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.analysis.util.ElisionFilter;
import org.elasticsearch.analysis.common.ASCIIFoldingTokenFilterFactory;
import org.elasticsearch.analysis.common.ApostropheFilterFactory;
import org.elasticsearch.analysis.common.ArabicAnalyzerProvider;
import org.elasticsearch.analysis.common.ArabicNormalizationFilterFactory;
import org.elasticsearch.analysis.common.ArabicStemTokenFilterFactory;
import org.elasticsearch.analysis.common.ArmenianAnalyzerProvider;
import org.elasticsearch.analysis.common.BasqueAnalyzerProvider;
import org.elasticsearch.analysis.common.BengaliAnalyzerProvider;
import org.elasticsearch.analysis.common.BengaliNormalizationFilterFactory;
import org.elasticsearch.analysis.common.BrazilianAnalyzerProvider;
import org.elasticsearch.analysis.common.BrazilianStemTokenFilterFactory;
import org.elasticsearch.analysis.common.BulgarianAnalyzerProvider;
import org.elasticsearch.analysis.common.CJKBigramFilterFactory;
import org.elasticsearch.analysis.common.CJKWidthFilterFactory;
import org.elasticsearch.analysis.common.CatalanAnalyzerProvider;
import org.elasticsearch.analysis.common.CharGroupTokenizerFactory;
import org.elasticsearch.analysis.common.ChineseAnalyzerProvider;
import org.elasticsearch.analysis.common.CjkAnalyzerProvider;
import org.elasticsearch.analysis.common.ClassicFilterFactory;
import org.elasticsearch.analysis.common.ClassicTokenizerFactory;
import org.elasticsearch.analysis.common.CommonGramsTokenFilterFactory;
import org.elasticsearch.analysis.common.CzechAnalyzerProvider;
import org.elasticsearch.analysis.common.CzechStemTokenFilterFactory;
import org.elasticsearch.analysis.common.DanishAnalyzerProvider;
import org.elasticsearch.analysis.common.DecimalDigitFilterFactory;
import org.elasticsearch.analysis.common.DelimitedPayloadTokenFilterFactory;
import org.elasticsearch.analysis.common.DictionaryCompoundWordTokenFilterFactory;
import org.elasticsearch.analysis.common.DutchAnalyzerProvider;
import org.elasticsearch.analysis.common.DutchStemTokenFilterFactory;
import org.elasticsearch.analysis.common.EdgeNGramTokenFilterFactory;
import org.elasticsearch.analysis.common.EdgeNGramTokenizerFactory;
import org.elasticsearch.analysis.common.ElisionTokenFilterFactory;
import org.elasticsearch.analysis.common.EnglishAnalyzerProvider;
import org.elasticsearch.analysis.common.FingerprintAnalyzerProvider;
import org.elasticsearch.analysis.common.FingerprintTokenFilterFactory;
import org.elasticsearch.analysis.common.FinnishAnalyzerProvider;
import org.elasticsearch.analysis.common.FlattenGraphTokenFilterFactory;
import org.elasticsearch.analysis.common.FrenchAnalyzerProvider;
import org.elasticsearch.analysis.common.FrenchStemTokenFilterFactory;
import org.elasticsearch.analysis.common.GalicianAnalyzerProvider;
import org.elasticsearch.analysis.common.GermanAnalyzerProvider;
import org.elasticsearch.analysis.common.GermanNormalizationFilterFactory;
import org.elasticsearch.analysis.common.GermanStemTokenFilterFactory;
import org.elasticsearch.analysis.common.GreekAnalyzerProvider;
import org.elasticsearch.analysis.common.HindiAnalyzerProvider;
import org.elasticsearch.analysis.common.HindiNormalizationFilterFactory;
import org.elasticsearch.analysis.common.HtmlStripCharFilterFactory;
import org.elasticsearch.analysis.common.HungarianAnalyzerProvider;
import org.elasticsearch.analysis.common.HyphenationCompoundWordTokenFilterFactory;
import org.elasticsearch.analysis.common.IndicNormalizationFilterFactory;
import org.elasticsearch.analysis.common.IndonesianAnalyzerProvider;
import org.elasticsearch.analysis.common.IrishAnalyzerProvider;
import org.elasticsearch.analysis.common.ItalianAnalyzerProvider;
import org.elasticsearch.analysis.common.KStemTokenFilterFactory;
import org.elasticsearch.analysis.common.KeepTypesFilterFactory;
import org.elasticsearch.analysis.common.KeepWordFilterFactory;
import org.elasticsearch.analysis.common.KeywordMarkerTokenFilterFactory;
import org.elasticsearch.analysis.common.KeywordTokenizerFactory;
import org.elasticsearch.analysis.common.LatvianAnalyzerProvider;
import org.elasticsearch.analysis.common.LegacyDelimitedPayloadTokenFilterFactory;
import org.elasticsearch.analysis.common.LengthTokenFilterFactory;
import org.elasticsearch.analysis.common.LetterTokenizerFactory;
import org.elasticsearch.analysis.common.LimitTokenCountFilterFactory;
import org.elasticsearch.analysis.common.LithuanianAnalyzerProvider;
import org.elasticsearch.analysis.common.LowerCaseTokenFilterFactory;
import org.elasticsearch.analysis.common.LowerCaseTokenizerFactory;
import org.elasticsearch.analysis.common.MappingCharFilterFactory;
import org.elasticsearch.analysis.common.MinHashTokenFilterFactory;
import org.elasticsearch.analysis.common.MultiplexerTokenFilterFactory;
import org.elasticsearch.analysis.common.NGramTokenFilterFactory;
import org.elasticsearch.analysis.common.NGramTokenizerFactory;
import org.elasticsearch.analysis.common.NorwegianAnalyzerProvider;
import org.elasticsearch.analysis.common.PathHierarchyTokenizerFactory;
import org.elasticsearch.analysis.common.PatternAnalyzer;
import org.elasticsearch.analysis.common.PatternAnalyzerProvider;
import org.elasticsearch.analysis.common.PatternCaptureGroupTokenFilterFactory;
import org.elasticsearch.analysis.common.PatternReplaceCharFilterFactory;
import org.elasticsearch.analysis.common.PatternReplaceTokenFilterFactory;
import org.elasticsearch.analysis.common.PatternTokenizerFactory;
import org.elasticsearch.analysis.common.PersianAnalyzerProvider;
import org.elasticsearch.analysis.common.PersianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.PorterStemTokenFilterFactory;
import org.elasticsearch.analysis.common.PortugueseAnalyzerProvider;
import org.elasticsearch.analysis.common.RemoveDuplicatesTokenFilterFactory;
import org.elasticsearch.analysis.common.ReverseTokenFilterFactory;
import org.elasticsearch.analysis.common.RomanianAnalyzerProvider;
import org.elasticsearch.analysis.common.RussianAnalyzerProvider;
import org.elasticsearch.analysis.common.RussianStemTokenFilterFactory;
import org.elasticsearch.analysis.common.ScandinavianFoldingFilterFactory;
import org.elasticsearch.analysis.common.ScandinavianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.SerbianNormalizationFilterFactory;
import org.elasticsearch.analysis.common.SimplePatternSplitTokenizerFactory;
import org.elasticsearch.analysis.common.SimplePatternTokenizerFactory;
import org.elasticsearch.analysis.common.SnowballAnalyzer;
import org.elasticsearch.analysis.common.SnowballAnalyzerProvider;
import org.elasticsearch.analysis.common.SnowballTokenFilterFactory;
import org.elasticsearch.analysis.common.SoraniAnalyzerProvider;
import org.elasticsearch.analysis.common.SoraniNormalizationFilterFactory;
import org.elasticsearch.analysis.common.SpanishAnalyzerProvider;
import org.elasticsearch.analysis.common.StandardHtmlStripAnalyzer;
import org.elasticsearch.analysis.common.StandardHtmlStripAnalyzerProvider;
import org.elasticsearch.analysis.common.StemmerOverrideTokenFilterFactory;
import org.elasticsearch.analysis.common.StemmerTokenFilterFactory;
import org.elasticsearch.analysis.common.SwedishAnalyzerProvider;
import org.elasticsearch.analysis.common.ThaiAnalyzerProvider;
import org.elasticsearch.analysis.common.ThaiTokenizerFactory;
import org.elasticsearch.analysis.common.TrimTokenFilterFactory;
import org.elasticsearch.analysis.common.TruncateTokenFilterFactory;
import org.elasticsearch.analysis.common.TurkishAnalyzerProvider;
import org.elasticsearch.analysis.common.UAX29URLEmailTokenizerFactory;
import org.elasticsearch.analysis.common.UniqueTokenFilter;
import org.elasticsearch.analysis.common.UniqueTokenFilterFactory;
import org.elasticsearch.analysis.common.UpperCaseTokenFilterFactory;
import org.elasticsearch.analysis.common.WhitespaceTokenizerFactory;
import org.elasticsearch.analysis.common.WordDelimiterGraphTokenFilterFactory;
import org.elasticsearch.analysis.common.WordDelimiterTokenFilterFactory;
import org.elasticsearch.analysis.common.XLowerCaseTokenizer;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreConfiguredCharFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenFilter;
import org.elasticsearch.index.analysis.PreConfiguredTokenizer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;

public class CommonAnalysisPlugin
extends Plugin
implements AnalysisPlugin {
    @Override
    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        return Collections.emptyList();
    }

    @Override
    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        TreeMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> analyzers = new TreeMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>>();
        analyzers.put("fingerprint", FingerprintAnalyzerProvider::new);
        analyzers.put("standard_html_strip", StandardHtmlStripAnalyzerProvider::new);
        analyzers.put("pattern", PatternAnalyzerProvider::new);
        analyzers.put("snowball", SnowballAnalyzerProvider::new);
        analyzers.put("arabic", ArabicAnalyzerProvider::new);
        analyzers.put("armenian", ArmenianAnalyzerProvider::new);
        analyzers.put("basque", BasqueAnalyzerProvider::new);
        analyzers.put("bengali", BengaliAnalyzerProvider::new);
        analyzers.put("brazilian", BrazilianAnalyzerProvider::new);
        analyzers.put("bulgarian", BulgarianAnalyzerProvider::new);
        analyzers.put("catalan", CatalanAnalyzerProvider::new);
        analyzers.put("chinese", ChineseAnalyzerProvider::new);
        analyzers.put("cjk", CjkAnalyzerProvider::new);
        analyzers.put("czech", CzechAnalyzerProvider::new);
        analyzers.put("danish", DanishAnalyzerProvider::new);
        analyzers.put("dutch", DutchAnalyzerProvider::new);
        analyzers.put("english", EnglishAnalyzerProvider::new);
        analyzers.put("finnish", FinnishAnalyzerProvider::new);
        analyzers.put("french", FrenchAnalyzerProvider::new);
        analyzers.put("galician", GalicianAnalyzerProvider::new);
        analyzers.put("german", GermanAnalyzerProvider::new);
        analyzers.put("greek", GreekAnalyzerProvider::new);
        analyzers.put("hindi", HindiAnalyzerProvider::new);
        analyzers.put("hungarian", HungarianAnalyzerProvider::new);
        analyzers.put("indonesian", IndonesianAnalyzerProvider::new);
        analyzers.put("irish", IrishAnalyzerProvider::new);
        analyzers.put("italian", ItalianAnalyzerProvider::new);
        analyzers.put("latvian", LatvianAnalyzerProvider::new);
        analyzers.put("lithuanian", LithuanianAnalyzerProvider::new);
        analyzers.put("norwegian", NorwegianAnalyzerProvider::new);
        analyzers.put("persian", PersianAnalyzerProvider::new);
        analyzers.put("portuguese", PortugueseAnalyzerProvider::new);
        analyzers.put("romanian", RomanianAnalyzerProvider::new);
        analyzers.put("russian", RussianAnalyzerProvider::new);
        analyzers.put("sorani", SoraniAnalyzerProvider::new);
        analyzers.put("spanish", SpanishAnalyzerProvider::new);
        analyzers.put("swedish", SwedishAnalyzerProvider::new);
        analyzers.put("turkish", TurkishAnalyzerProvider::new);
        analyzers.put("thai", ThaiAnalyzerProvider::new);
        return analyzers;
    }

    @Override
    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        filters.put("apostrophe", ApostropheFilterFactory::new);
        filters.put("arabic_normalization", ArabicNormalizationFilterFactory::new);
        filters.put("arabic_stem", ArabicStemTokenFilterFactory::new);
        filters.put("asciifolding", ASCIIFoldingTokenFilterFactory::new);
        filters.put("bengali_normalization", BengaliNormalizationFilterFactory::new);
        filters.put("brazilian_stem", BrazilianStemTokenFilterFactory::new);
        filters.put("cjk_bigram", CJKBigramFilterFactory::new);
        filters.put("cjk_width", CJKWidthFilterFactory::new);
        filters.put("classic", ClassicFilterFactory::new);
        filters.put("czech_stem", CzechStemTokenFilterFactory::new);
        filters.put("common_grams", AnalysisPlugin.requiresAnalysisSettings(CommonGramsTokenFilterFactory::new));
        filters.put("decimal_digit", DecimalDigitFilterFactory::new);
        filters.put("delimited_payload_filter", LegacyDelimitedPayloadTokenFilterFactory::new);
        filters.put("delimited_payload", DelimitedPayloadTokenFilterFactory::new);
        filters.put("dictionary_decompounder", AnalysisPlugin.requiresAnalysisSettings(DictionaryCompoundWordTokenFilterFactory::new));
        filters.put("dutch_stem", DutchStemTokenFilterFactory::new);
        filters.put("edge_ngram", EdgeNGramTokenFilterFactory::new);
        filters.put("elision", ElisionTokenFilterFactory::new);
        filters.put("fingerprint", FingerprintTokenFilterFactory::new);
        filters.put("flatten_graph", FlattenGraphTokenFilterFactory::new);
        filters.put("french_stem", FrenchStemTokenFilterFactory::new);
        filters.put("german_normalization", GermanNormalizationFilterFactory::new);
        filters.put("german_stem", GermanStemTokenFilterFactory::new);
        filters.put("hindi_normalization", HindiNormalizationFilterFactory::new);
        filters.put("hyphenation_decompounder", AnalysisPlugin.requiresAnalysisSettings(HyphenationCompoundWordTokenFilterFactory::new));
        filters.put("indic_normalization", IndicNormalizationFilterFactory::new);
        filters.put("keep", AnalysisPlugin.requiresAnalysisSettings(KeepWordFilterFactory::new));
        filters.put("keep_types", AnalysisPlugin.requiresAnalysisSettings(KeepTypesFilterFactory::new));
        filters.put("keyword_marker", AnalysisPlugin.requiresAnalysisSettings(KeywordMarkerTokenFilterFactory::new));
        filters.put("kstem", KStemTokenFilterFactory::new);
        filters.put("length", LengthTokenFilterFactory::new);
        filters.put("limit", LimitTokenCountFilterFactory::new);
        filters.put("lowercase", LowerCaseTokenFilterFactory::new);
        filters.put("min_hash", MinHashTokenFilterFactory::new);
        filters.put("multiplexer", MultiplexerTokenFilterFactory::new);
        filters.put("ngram", NGramTokenFilterFactory::new);
        filters.put("pattern_capture", AnalysisPlugin.requiresAnalysisSettings(PatternCaptureGroupTokenFilterFactory::new));
        filters.put("pattern_replace", AnalysisPlugin.requiresAnalysisSettings(PatternReplaceTokenFilterFactory::new));
        filters.put("persian_normalization", PersianNormalizationFilterFactory::new);
        filters.put("porter_stem", PorterStemTokenFilterFactory::new);
        filters.put("remove_duplicates", RemoveDuplicatesTokenFilterFactory::new);
        filters.put("reverse", ReverseTokenFilterFactory::new);
        filters.put("russian_stem", RussianStemTokenFilterFactory::new);
        filters.put("scandinavian_folding", ScandinavianFoldingFilterFactory::new);
        filters.put("scandinavian_normalization", ScandinavianNormalizationFilterFactory::new);
        filters.put("serbian_normalization", SerbianNormalizationFilterFactory::new);
        filters.put("snowball", SnowballTokenFilterFactory::new);
        filters.put("sorani_normalization", SoraniNormalizationFilterFactory::new);
        filters.put("stemmer_override", AnalysisPlugin.requiresAnalysisSettings(StemmerOverrideTokenFilterFactory::new));
        filters.put("stemmer", StemmerTokenFilterFactory::new);
        filters.put("trim", TrimTokenFilterFactory::new);
        filters.put("truncate", AnalysisPlugin.requiresAnalysisSettings(TruncateTokenFilterFactory::new));
        filters.put("unique", UniqueTokenFilterFactory::new);
        filters.put("uppercase", UpperCaseTokenFilterFactory::new);
        filters.put("word_delimiter_graph", WordDelimiterGraphTokenFilterFactory::new);
        filters.put("word_delimiter", WordDelimiterTokenFilterFactory::new);
        return filters;
    }

    @Override
    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> filters = new TreeMap<String, AnalysisModule.AnalysisProvider<CharFilterFactory>>();
        filters.put("html_strip", HtmlStripCharFilterFactory::new);
        filters.put("pattern_replace", AnalysisPlugin.requiresAnalysisSettings(PatternReplaceCharFilterFactory::new));
        filters.put("mapping", AnalysisPlugin.requiresAnalysisSettings(MappingCharFilterFactory::new));
        return filters;
    }

    @Override
    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> tokenizers = new TreeMap<String, AnalysisModule.AnalysisProvider<TokenizerFactory>>();
        tokenizers.put("simple_pattern", SimplePatternTokenizerFactory::new);
        tokenizers.put("simple_pattern_split", SimplePatternSplitTokenizerFactory::new);
        tokenizers.put("thai", ThaiTokenizerFactory::new);
        tokenizers.put("ngram", NGramTokenizerFactory::new);
        tokenizers.put("edge_ngram", EdgeNGramTokenizerFactory::new);
        tokenizers.put("char_group", CharGroupTokenizerFactory::new);
        tokenizers.put("classic", ClassicTokenizerFactory::new);
        tokenizers.put("letter", LetterTokenizerFactory::new);
        tokenizers.put("lowercase", LowerCaseTokenizerFactory::new);
        tokenizers.put("path_hierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.put("PathHierarchy", PathHierarchyTokenizerFactory::new);
        tokenizers.put("pattern", PatternTokenizerFactory::new);
        tokenizers.put("uax_url_email", UAX29URLEmailTokenizerFactory::new);
        tokenizers.put("whitespace", WhitespaceTokenizerFactory::new);
        tokenizers.put("keyword", KeywordTokenizerFactory::new);
        return tokenizers;
    }

    @Override
    public List<PreBuiltAnalyzerProviderFactory> getPreBuiltAnalyzerProviderFactories() {
        ArrayList<PreBuiltAnalyzerProviderFactory> analyzers = new ArrayList<PreBuiltAnalyzerProviderFactory>();
        analyzers.add(new PreBuiltAnalyzerProviderFactory("standard_html_strip", PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, () -> new StandardHtmlStripAnalyzer(CharArraySet.EMPTY_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("pattern", PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, () -> new PatternAnalyzer(Regex.compile("\\W+", null), true, CharArraySet.EMPTY_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("snowball", PreBuiltCacheFactory.CachingStrategy.LUCENE, () -> new SnowballAnalyzer("English", EnglishAnalyzer.ENGLISH_STOP_WORDS_SET)));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("arabic", PreBuiltCacheFactory.CachingStrategy.LUCENE, ArabicAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("armenian", PreBuiltCacheFactory.CachingStrategy.LUCENE, ArmenianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("basque", PreBuiltCacheFactory.CachingStrategy.LUCENE, BasqueAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("bengali", PreBuiltCacheFactory.CachingStrategy.LUCENE, BengaliAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("brazilian", PreBuiltCacheFactory.CachingStrategy.LUCENE, BrazilianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("bulgarian", PreBuiltCacheFactory.CachingStrategy.LUCENE, BulgarianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("catalan", PreBuiltCacheFactory.CachingStrategy.LUCENE, CatalanAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("chinese", PreBuiltCacheFactory.CachingStrategy.ONE, StandardAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("cjk", PreBuiltCacheFactory.CachingStrategy.LUCENE, CJKAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("czech", PreBuiltCacheFactory.CachingStrategy.LUCENE, CzechAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("danish", PreBuiltCacheFactory.CachingStrategy.LUCENE, DanishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("dutch", PreBuiltCacheFactory.CachingStrategy.LUCENE, DutchAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("english", PreBuiltCacheFactory.CachingStrategy.LUCENE, EnglishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("finnish", PreBuiltCacheFactory.CachingStrategy.LUCENE, FinnishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("french", PreBuiltCacheFactory.CachingStrategy.LUCENE, FrenchAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("galician", PreBuiltCacheFactory.CachingStrategy.LUCENE, GalicianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("german", PreBuiltCacheFactory.CachingStrategy.LUCENE, GermanAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("greek", PreBuiltCacheFactory.CachingStrategy.LUCENE, GreekAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("hindi", PreBuiltCacheFactory.CachingStrategy.LUCENE, HindiAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("hungarian", PreBuiltCacheFactory.CachingStrategy.LUCENE, HungarianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("indonesian", PreBuiltCacheFactory.CachingStrategy.LUCENE, IndonesianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("irish", PreBuiltCacheFactory.CachingStrategy.LUCENE, IrishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("italian", PreBuiltCacheFactory.CachingStrategy.LUCENE, ItalianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("latvian", PreBuiltCacheFactory.CachingStrategy.LUCENE, LatvianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("lithuanian", PreBuiltCacheFactory.CachingStrategy.LUCENE, LithuanianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("norwegian", PreBuiltCacheFactory.CachingStrategy.LUCENE, NorwegianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("persian", PreBuiltCacheFactory.CachingStrategy.LUCENE, PersianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("portuguese", PreBuiltCacheFactory.CachingStrategy.LUCENE, PortugueseAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("romanian", PreBuiltCacheFactory.CachingStrategy.LUCENE, RomanianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("russian", PreBuiltCacheFactory.CachingStrategy.LUCENE, RussianAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("sorani", PreBuiltCacheFactory.CachingStrategy.LUCENE, SoraniAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("spanish", PreBuiltCacheFactory.CachingStrategy.LUCENE, SpanishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("swedish", PreBuiltCacheFactory.CachingStrategy.LUCENE, SwedishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("turkish", PreBuiltCacheFactory.CachingStrategy.LUCENE, TurkishAnalyzer::new));
        analyzers.add(new PreBuiltAnalyzerProviderFactory("thai", PreBuiltCacheFactory.CachingStrategy.LUCENE, ThaiAnalyzer::new));
        return analyzers;
    }

    @Override
    public List<PreConfiguredCharFilter> getPreConfiguredCharFilters() {
        ArrayList<PreConfiguredCharFilter> filters = new ArrayList<PreConfiguredCharFilter>();
        filters.add(PreConfiguredCharFilter.singleton("html_strip", false, HTMLStripCharFilter::new));
        return filters;
    }

    @Override
    public List<PreConfiguredTokenFilter> getPreConfiguredTokenFilters() {
        ArrayList<PreConfiguredTokenFilter> filters = new ArrayList<PreConfiguredTokenFilter>();
        filters.add(PreConfiguredTokenFilter.singleton("apostrophe", false, ApostropheFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("arabic_normalization", true, ArabicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("arabic_stem", false, ArabicStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("asciifolding", true, ASCIIFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("bengali_normalization", true, BengaliNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("brazilian_stem", false, BrazilianStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("cjk_bigram", false, CJKBigramFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("cjk_width", true, CJKWidthFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("classic", false, ClassicFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("common_grams", false, input -> new CommonGramsFilter(input, CharArraySet.EMPTY_SET)));
        filters.add(PreConfiguredTokenFilter.singleton("czech_stem", false, CzechStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("decimal_digit", true, DecimalDigitFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("delimited_payload_filter", false, input -> new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER)));
        filters.add(PreConfiguredTokenFilter.singleton("delimited_payload", false, input -> new DelimitedPayloadTokenFilter(input, '|', DelimitedPayloadTokenFilterFactory.DEFAULT_ENCODER)));
        filters.add(PreConfiguredTokenFilter.singleton("dutch_stem", false, input -> new SnowballFilter(input, (SnowballProgram)new DutchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton("edge_ngram", false, input -> new EdgeNGramTokenFilter(input, 1, 2, false)));
        filters.add(PreConfiguredTokenFilter.singleton("elision", true, input -> new ElisionFilter(input, FrenchAnalyzer.DEFAULT_ARTICLES)));
        filters.add(PreConfiguredTokenFilter.singleton("french_stem", false, input -> new SnowballFilter(input, (SnowballProgram)new FrenchStemmer())));
        filters.add(PreConfiguredTokenFilter.singleton("german_normalization", true, GermanNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("german_stem", false, GermanStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("hindi_normalization", true, HindiNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("indic_normalization", true, IndicNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("keyword_repeat", false, KeywordRepeatFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("kstem", false, KStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("length", false, input -> new LengthFilter(input, 0, Integer.MAX_VALUE)));
        filters.add(PreConfiguredTokenFilter.singleton("limit", false, input -> new LimitTokenCountFilter(input, 1, false)));
        filters.add(PreConfiguredTokenFilter.singleton("ngram", false, reader -> new NGramTokenFilter(reader, 1, 2, false)));
        filters.add(PreConfiguredTokenFilter.singleton("persian_normalization", true, PersianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("porter_stem", false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("reverse", false, ReverseStringFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("russian_stem", false, input -> new SnowballFilter(input, "Russian")));
        filters.add(PreConfiguredTokenFilter.singleton("scandinavian_folding", true, ScandinavianFoldingFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("scandinavian_normalization", true, ScandinavianNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("shingle", false, input -> {
            ShingleFilter ts = new ShingleFilter(input);
            ts.addAttribute(DisableGraphAttribute.class);
            return ts;
        }));
        filters.add(PreConfiguredTokenFilter.singleton("snowball", false, input -> new SnowballFilter(input, "English")));
        filters.add(PreConfiguredTokenFilter.singleton("sorani_normalization", true, SoraniNormalizationFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("stemmer", false, PorterStemFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("stop", false, input -> new StopFilter(input, EnglishAnalyzer.ENGLISH_STOP_WORDS_SET)));
        filters.add(PreConfiguredTokenFilter.singleton("trim", true, TrimFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("truncate", false, input -> new TruncateTokenFilter(input, 10)));
        filters.add(PreConfiguredTokenFilter.singleton("type_as_payload", false, TypeAsPayloadTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("unique", false, UniqueTokenFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("uppercase", true, UpperCaseFilter::new));
        filters.add(PreConfiguredTokenFilter.singleton("word_delimiter", false, input -> new WordDelimiterFilter(input, 451, null)));
        filters.add(PreConfiguredTokenFilter.singleton("word_delimiter_graph", false, input -> new WordDelimiterGraphFilter(input, 451, null)));
        return filters;
    }

    @Override
    public List<PreConfiguredTokenizer> getPreConfiguredTokenizers() {
        ArrayList<PreConfiguredTokenizer> tokenizers = new ArrayList<PreConfiguredTokenizer>();
        tokenizers.add(PreConfiguredTokenizer.singleton("keyword", KeywordTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("classic", ClassicTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("uax_url_email", UAX29URLEmailTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("path_hierarchy", PathHierarchyTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("letter", LetterTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("whitespace", WhitespaceTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("ngram", NGramTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("edge_ngram", () -> new EdgeNGramTokenizer(1, 1), null));
        tokenizers.add(PreConfiguredTokenizer.singleton("pattern", () -> new PatternTokenizer(Regex.compile("\\W+", null), -1), null));
        tokenizers.add(PreConfiguredTokenizer.singleton("thai", ThaiTokenizer::new, null));
        tokenizers.add(PreConfiguredTokenizer.singleton("lowercase", XLowerCaseTokenizer::new, () -> new TokenFilterFactory(){

            @Override
            public String name() {
                return "lowercase";
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return new LowerCaseFilter(tokenStream);
            }
        }));
        tokenizers.add(PreConfiguredTokenizer.singleton("PathHierarchy", PathHierarchyTokenizer::new, null));
        return tokenizers;
    }
}

