/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportWriteAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
extends TransportReplicationAction<Request, ReplicaRequest, Response> {
    protected TransportWriteAction(String actionName, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, Writeable.Reader<Request> reader, Writeable.Reader<ReplicaRequest> replicaReader, String executor, boolean forceExecutionOnPrimary) {
        super(actionName, transportService, clusterService, indicesService, threadPool, shardStateAction, reader, replicaReader, executor, false, forceExecutionOnPrimary);
    }

    protected static Translog.Location syncOperationResultOrThrow(Engine.Result operationResult, Translog.Location currentLocation) throws Exception {
        if (operationResult.getFailure() != null) {
            Exception failure = operationResult.getFailure();
            assert (failure instanceof MapperParsingException) : "expected mapper parsing failures. got " + failure;
            throw failure;
        }
        Translog.Location location = TransportWriteAction.locationToSync(currentLocation, operationResult.getTranslogLocation());
        return location;
    }

    public static Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    @Override
    protected ReplicationOperation.Replicas<ReplicaRequest> newReplicasProxy() {
        return new WriteActionReplicasProxy();
    }

    @Override
    protected abstract void shardOperationOnPrimary(Request var1, IndexShard var2, ActionListener<TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>> var3);

    @Override
    protected abstract WriteReplicaResult<ReplicaRequest> shardOperationOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

    @Override
    protected ClusterBlockLevel globalBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return ClusterBlockLevel.WRITE;
    }

    class WriteActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        WriteActionReplicasProxy() {
        }

        @Override
        public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
            if (!TransportActions.isShardNotAvailableException(exception)) {
                TransportWriteAction.this.logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)replica.shardId(), (Object)message), (Throwable)exception);
            }
            TransportWriteAction.this.shardStateAction.remoteShardFailed(replica.shardId(), replica.allocationId().getId(), primaryTerm, true, message, exception, listener);
        }

        @Override
        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportWriteAction.this.shardStateAction.remoteShardFailed(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }

    public static class WriteReplicaResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>>
    extends TransportReplicationAction.ReplicaResult
    implements RespondingWriteResult {
        public final Translog.Location location;
        boolean finishedAsyncActions;
        private ActionListener<TransportResponse.Empty> listener;

        public WriteReplicaResult(ReplicaRequest request, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard replica, Logger logger) {
            super(operationFailure);
            this.location = location;
            if (operationFailure != null) {
                this.finishedAsyncActions = true;
            } else {
                new AsyncAfterWriteAction(replica, location, this).run();
            }
        }

        @Override
        public void respond(ActionListener<TransportResponse.Empty> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public void onFailure(Exception ex) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(ex);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }

    static final class AsyncAfterWriteAction {
        private final Translog.Location location;
        private final boolean sync;
        private final AtomicInteger pendingOps = new AtomicInteger(1);
        private final AtomicBoolean refreshed = new AtomicBoolean(false);
        private final AtomicReference<Exception> syncFailure = new AtomicReference<Object>(null);
        private final RespondingWriteResult respond;
        private final IndexShard indexShard;

        AsyncAfterWriteAction(IndexShard indexShard, @Nullable Translog.Location location, RespondingWriteResult respond) {
            this.indexShard = indexShard;
            this.respond = respond;
            this.location = location;
            this.sync = indexShard.getTranslogDurability() == Translog.Durability.REQUEST && location != null;
            if (this.sync) {
                this.pendingOps.incrementAndGet();
            }
            assert (this.pendingOps.get() >= 0 && this.pendingOps.get() <= 3) : "pendingOpts was: " + this.pendingOps.get();
        }

        private void maybeFinish() {
            int numPending = this.pendingOps.decrementAndGet();
            if (numPending == 0) {
                if (this.syncFailure.get() != null) {
                    this.respond.onFailure(this.syncFailure.get());
                } else {
                    this.respond.onSuccess(this.refreshed.get());
                }
            }
            assert (numPending >= 0 && numPending <= 2) : "numPending must either 2, 1 or 0 but was " + numPending;
        }

        void run() {
            this.indexShard.afterWriteOperation();
            this.maybeFinish();
            if (this.sync) {
                assert (this.pendingOps.get() > 0);
                this.indexShard.sync(this.location, ex -> {
                    this.syncFailure.set((Exception)ex);
                    this.maybeFinish();
                });
            }
        }
    }

    static interface RespondingWriteResult {
        public void onSuccess(boolean var1);

        public void onFailure(Exception var1);
    }

    public static class WritePrimaryResult<ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse>
    extends TransportReplicationAction.PrimaryResult<ReplicaRequest, Response>
    implements RespondingWriteResult {
        boolean finishedAsyncActions;
        public final Translog.Location location;
        public final IndexShard primary;
        ActionListener<Response> listener = null;

        public WritePrimaryResult(ReplicaRequest request, @Nullable Response finalResponse, @Nullable Translog.Location location, @Nullable Exception operationFailure, IndexShard primary) {
            super(request, finalResponse, operationFailure);
            this.location = location;
            this.primary = primary;
            assert (location == null || operationFailure == null) : "expected either failure to be null or translog location to be null, but found: [" + location + "] translog location and [" + operationFailure + "] failure";
            if (operationFailure != null) {
                this.finishedAsyncActions = true;
            } else {
                new AsyncAfterWriteAction(primary, location, this).run();
            }
        }

        @Override
        public synchronized void respond(ActionListener<Response> listener) {
            this.listener = listener;
            this.respondIfPossible(null);
        }

        protected void respondIfPossible(Exception ex) {
            if (this.finishedAsyncActions && this.listener != null) {
                if (ex == null) {
                    super.respond(this.listener);
                } else {
                    this.listener.onFailure(ex);
                }
            }
        }

        @Override
        public synchronized void onFailure(Exception exception) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(exception);
        }

        @Override
        public synchronized void onSuccess(boolean forcedRefresh) {
            this.finishedAsyncActions = true;
            this.respondIfPossible(null);
        }
    }
}

