/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public abstract class BaseNodesResponse<TNodeResponse extends BaseNodeResponse>
extends TransportResponse {
    private final ClusterName clusterName;
    private final List<FailedNodeException> failures;
    private final List<TNodeResponse> nodes;

    protected BaseNodesResponse(ClusterName clusterName, List<TNodeResponse> nodes, List<FailedNodeException> failures) {
        this.clusterName = Objects.requireNonNull(clusterName);
        this.failures = Objects.requireNonNull(failures);
        this.nodes = Objects.requireNonNull(nodes);
    }

    public List<FailedNodeException> failures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public List<TNodeResponse> getNodes() {
        return this.nodes;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        this.writeNodesTo(out, this.nodes);
        out.writeList(this.failures);
    }

    protected abstract void writeNodesTo(StreamOutput var1, List<TNodeResponse> var2) throws IOException;
}

