/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends TransportRequest {
    private final DiscoveryNode[] concreteNodes;
    private TimeValue timeout;

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.concreteNodes = concreteNodes;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public DiscoveryNode[] concreteNodes() {
        return this.concreteNodes;
    }

    public BaseNodesRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_4_1_0)) {
            in.readStringArray();
        }
        this.concreteNodes = in.readOptionalArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.timeout = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_4_1_0)) {
            out.writeStringArrayNullable(null);
        }
        out.writeOptionalArray(this.concreteNodes);
        out.writeOptionalTimeValue(this.timeout);
    }
}

